DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-10
      0.00000000000000E+00  -1.09275949882143E-11   0.00000000000000E+00  -1.13598892638640E-13   1.47925090624689E-22
      1.09276431119067E-08   1.09275295130142E-08  -7.99416023833534E-19  -2.46304709481801E-01  -2.46304709481827E-01
      0.00000000000000E+00   0.00000000000000E+00   2.57730110060811E-11   0.00000000000000E+00   2.57730110060811E-11
      3.71361512117044E-18  -2.46304709481801E-01  -2.42853835801530E-01   0.00000000000000E+00   1.25917339686573E-13
     -9.82471207960986E-23  -1.09534284413599E-08  -1.09533025240203E-08  -2.91419909733691E-18
      1.17500000000000E-09
      0.00000000000000E+00  -9.88047313931131E-12   0.00000000000000E+00  -7.70444283231125E-14   1.35383478571271E-22
      9.88050970492237E-09   9.88043266049419E-09  -8.08679659960903E-19  -2.42051569355066E-01  -2.42051569355093E-01
      0.00000000000000E+00   0.00000000000000E+00   2.71332099231768E-11   0.00000000000000E+00   2.71332099231768E-11
      3.73193003786859E-18  -2.42051569355066E-01  -2.38930159062339E-01   0.00000000000000E+00   1.06144961967001E-13
     -9.81121148367369E-23  -9.90767201537924E-09  -9.90756587041737E-09  -2.92325037790768E-18
      2.08625000000000E-09
      0.00000000000000E+00  -8.88974395905372E-12   0.00000000000000E+00   4.41320549922170E-13   1.26216164113926E-22
      8.88982426941595E-09   8.89026558996600E-09  -8.18666931020537E-19  -2.37256267338036E-01  -2.37256267338062E-01
      0.00000000000000E+00   0.00000000000000E+00   2.66401452558266E-11   0.00000000000000E+00   2.66401452558266E-11
      3.75620587023296E-18  -2.37256267338132E-01  -2.34447122388685E-01   0.00000000000000E+00  -4.05059164192017E-13
     -9.79149887528855E-23  -8.91650067605753E-09  -8.91690573522182E-09  -2.93753893921242E-18
      3.31643750000000E-09
      0.00000000000000E+00  -7.97340901593423E-12   0.00000000000000E+00   5.00266746216779E-13   1.20310187196945E-22
      7.97342706508645E-09   7.97392733183278E-09  -8.29223136726283E-19  -2.31974899935401E-01  -2.31974899935426E-01
      0.00000000000000E+00   0.00000000000000E+00   2.45542838251818E-11   0.00000000000000E+00   2.45542838251818E-11
      3.78641224326615E-18  -2.31974899935389E-01  -2.29455119572074E-01   0.00000000000000E+00  -4.61883784999195E-13
     -9.76573175546893E-23  -7.99801973187287E-09  -7.99848161565796E-09  -2.95718910653986E-18
      4.97719062500000E-09
      0.00000000000000E+00  -7.14230598894332E-12   0.00000000000000E+00  -2.49511034643197E-14   1.17369280606809E-22
      7.14231600745678E-09   7.14229105635343E-09  -8.40153686401553E-19  -2.26319232763955E-01  -2.26319232763977E-01
      0.00000000000000E+00   0.00000000000000E+00   2.12451343438590E-11   0.00000000000000E+00   2.12451343438590E-11
      3.82169516651876E-18  -2.26319232763842E-01  -2.24062334577639E-01   0.00000000000000E+00   6.15801354930226E-14
     -9.73477008470278E-23  -7.16359777083269E-09  -7.16353619069729E-09  -2.98154148011720E-18
      7.21920734375000E-09
      0.00000000000000E+00  -6.40304769915994E-12   0.00000000000000E+00  -1.64646067053345E-14   1.16584024626915E-22
      6.40312369209953E-09   6.40310722749294E-09  -8.51180715035083E-19  -2.20472430859472E-01  -2.20472430859489E-01
      0.00000000000000E+00   0.00000000000000E+00   1.72031219373475E-11   0.00000000000000E+00   1.72031219373475E-11
      3.86026485351698E-18  -2.20472430859227E-01  -2.18449687330138E-01   0.00000000000000E+00   4.69251528328861E-14
     -9.70041588931906E-23  -6.42035727458303E-09  -6.42031034943029E-09  -3.00908413848190E-18
      1.02459299140625E-08
      0.00000000000000E+00  -5.76233881240023E-12   0.00000000000000E+00  -1.05893893331386E-14   1.17219336121351E-22
      5.76239269272507E-09   5.76238210333585E-09  -8.61914758790727E-19  -2.14693458932012E-01  -2.14693458932025E-01
      0.00000000000000E+00   0.00000000000000E+00   1.29705876847340E-11   0.00000000000000E+00   1.29705876847340E-11
      3.89952322401258E-18  -2.14693458931650E-01  -2.12873910579024E-01   0.00000000000000E+00   3.34141738714890E-14
     -9.66558355449650E-23  -5.77538610519437E-09  -5.77535269102059E-09  -3.03760846522186E-18
      1.43320053839844E-08
      0.00000000000000E+00  -5.22670030500593E-12   0.00000000000000E+00  -6.56829164378748E-15   1.18701328474705E-22
      5.22674035434122E-09   5.22673378604970E-09  -8.71856379050688E-19  -2.09300890690965E-01  -2.09300890690974E-01
      0.00000000000000E+00   0.00000000000000E+00   9.04462043575964E-12   0.00000000000000E+00   9.04462043575964E-12
      3.93648022570990E-18  -2.09300890690428E-01  -2.07651336409982E-01   0.00000000000000E+00   2.20094422144458E-14
     -9.97134129333483E-23  -5.23580041592758E-09  -5.23577840648546E-09  -3.06462384665921E-18
      1.93320053839844E-08
      0.00000000000000E+00  -4.82735938762761E-12   0.00000000000000E+00  -4.00831737357588E-15   1.20167424987327E-22
      4.82733869467837E-09   4.82733468636112E-09  -8.79920421743751E-19  -2.04918302156414E-01  -2.04918302156420E-01
      0.00000000000000E+00   0.00000000000000E+00   5.97971234163308E-12   0.00000000000000E+00   5.97971234163308E-12
      3.96637878741806E-18  -2.04918302155638E-01  -2.03395545165459E-01   0.00000000000000E+00   1.37876137828103E-14
     -9.61718122374423E-23  -4.83332818631644E-09  -4.83331439870275E-09  -3.08645836567431E-18
      2.43320053839844E-08
      0.00000000000000E+00  -4.57294946556276E-12   0.00000000000000E+00   1.49059991464455E-13   1.21104725932264E-22
      4.57300094247536E-09   4.57315000246695E-09  -8.85376491529090E-19  -2.01955532781492E-01  -2.01955532781496E-01
      0.00000000000000E+00   0.00000000000000E+00   4.00404023541749E-12   0.00000000000000E+00   4.00404023541749E-12
      3.98639898859515E-18  -2.01955532769666E-01  -2.00513527514404E-01   0.00000000000000E+00  -1.43418523220656E-13
     -9.57150791784049E-23  -4.57701062417904E-09  -4.57715404270236E-09  -3.10102249706606E-18
      2.93320053839844E-08
      0.00000000000000E+00  -4.40579204384506E-12   0.00000000000000E+00   6.20686802846265E-14   1.21854471060236E-22
      4.40579465325464E-09   4.40585672193504E-09  -8.89112976551624E-19  -1.99930064367906E-01  -1.99930064367909E-01
      0.00000000000000E+00   0.00000000000000E+00   2.71006168509940E-12   0.00000000000000E+00   2.71006168509940E-12
      3.99994929702065E-18  -1.99930064358241E-01  -1.98541145358192E-01   0.00000000000000E+00  -5.82138668431595E-14
     -9.59238464285263E-23  -4.40850856975321E-09  -4.40856678362014E-09  -3.11083632046902E-18
      3.43320053839844E-08
      0.00000000000000E+00  -4.29355777497746E-12   0.00000000000000E+00  -1.12886640293558E-15   1.22725853209139E-22
      4.29354986231602E-09   4.29354873344974E-09  -8.91690044154844E-19  -1.98535543529971E-01  -1.98535543529973E-01
      0.00000000000000E+00   0.00000000000000E+00   1.84977695694034E-12   0.00000000000000E+00   1.84977695694034E-12
      4.00919818180535E-18  -1.98535543520444E-01  -1.97182258465283E-01   0.00000000000000E+00   3.85377564474557E-15
     -9.91445169739997E-23  -4.29540236418223E-09  -4.29539851040668E-09  -3.11750813765050E-18
      3.93320053839844E-08
      0.00000000000000E+00  -4.21714295362080E-12   0.00000000000000E+00   3.85782730844807E-14   1.22866594369570E-22
      4.21717923032466E-09   4.21721780859787E-09  -8.93474932857802E-19  -1.97571096212824E-01  -1.97571096212825E-01
      0.00000000000000E+00   0.00000000000000E+00   1.27065692716170E-12   0.00000000000000E+00   1.27065692716170E-12
      4.01555146644115E-18  -1.97571096201350E-01  -1.96242054279126E-01   0.00000000000000E+00  -3.68814347116852E-14
     -9.52980407857879E-23  -4.21845158409022E-09  -4.21848846552503E-09  -3.12207653358336E-18
      4.43320053839844E-08
      0.00000000000000E+00  -4.16469960867530E-12   0.00000000000000E+00   2.21655005605351E-13   1.23113689890192E-22
      4.16474185364152E-09   4.16496350864725E-09  -8.94714001371455E-19  -1.96902274718351E-01  -1.96902274718352E-01
      0.00000000000000E+00   0.00000000000000E+00   8.76906396714974E-13   0.00000000000000E+00   8.76906396714974E-13
      4.01993599842473E-18  -1.96902274708422E-01  -1.95589877265458E-01   0.00000000000000E+00  -2.21180214692105E-13
     -9.49899932837995E-23  -4.16561923482918E-09  -4.16584041504396E-09  -3.12522199705328E-18
      4.93320053839844E-08
      0.00000000000000E+00  -4.12878831642716E-12   0.00000000000000E+00   8.39343609806038E-15   1.23375102097411E-22
      4.12871174548569E-09   4.12872013892191E-09  -8.95577269482488E-19  -1.96436874058204E-01  -1.96436874058205E-01
      0.00000000000000E+00   0.00000000000000E+00   6.07277723983188E-13   0.00000000000000E+00   6.07277723983188E-13
      4.02297238704465E-18  -1.96436874052156E-01  -1.95135912976303E-01   0.00000000000000E+00  -7.56868112685179E-15
     -9.53159959592943E-23  -4.12931984796467E-09  -4.12932741664589E-09  -3.12739511756216E-18
      5.43320053839844E-08
      0.00000000000000E+00  -4.10362285843230E-12   0.00000000000000E+00   4.99528366919900E-14   1.23464812190803E-22
      4.10366242099426E-09   4.10371237383108E-09  -8.96178460319142E-19  -1.96112917098577E-01  -1.96112917098578E-01
      0.00000000000000E+00   0.00000000000000E+00   4.21718255734052E-13   0.00000000000000E+00   4.21718255734052E-13
      4.02508097832332E-18  -1.96112917099394E-01  -1.94819906307416E-01   0.00000000000000E+00  -4.95224128859321E-14
     -9.54134416094990E-23  -4.10408456967383E-09  -4.10413409208682E-09  -3.12890251800418E-18
      5.93320053839844E-08
      0.00000000000000E+00  -4.08626420310007E-12   0.00000000000000E+00  -1.74942371978933E-16   1.23864327593525E-22
      4.08630410234435E-09   4.08630392740210E-09  -8.96597884169983E-19  -1.95887045191705E-01  -1.95887045191705E-01
      0.00000000000000E+00   0.00000000000000E+00   2.93325433282396E-13   0.00000000000000E+00   2.93325433282396E-13
      4.02654760548973E-18  -1.95887045202297E-01  -1.94599543647944E-01   0.00000000000000E+00   5.81679970805048E-16
     -9.47649499561024E-23  -4.08659783451526E-09  -4.08659725283539E-09  -3.12994972131975E-18
      6.43320053839844E-08
      0.00000000000000E+00  -4.07423254252589E-12   0.00000000000000E+00   1.16296701508723E-14   1.23640231762657E-22
      4.07420549683392E-09   4.07421712650420E-09  -8.96890420879308E-19  -1.95729541184201E-01  -1.95729541184201E-01
      0.00000000000000E+00   0.00000000000000E+00   2.04308832771834E-13   0.00000000000000E+00   2.04308832771834E-13
      4.02756914965359E-18  -1.95729541207945E-01  -1.94445879383550E-01   0.00000000000000E+00  -1.13820189781028E-14
     -9.26857171385038E-23  -4.07441005331790E-09  -4.07442143533697E-09  -3.13067872877428E-18
      6.93320053839844E-08
      0.00000000000000E+00  -4.06578282670279E-12   0.00000000000000E+00   3.95177546973138E-16   1.23686987715439E-22
      4.06578772485732E-09   4.06578812003499E-09  -8.97094639692213E-19  -1.95619621870862E-01  -1.95619621870862E-01
      0.00000000000000E+00   0.00000000000000E+00   1.42412423881749E-13   0.00000000000000E+00   1.42412423881749E-13
      4.02828121177300E-18  -1.95619621909725E-01  -1.94338631624798E-01   0.00000000000000E+00  -2.00262785041596E-16
     -9.50159264617060E-23  -4.06593033219599E-09  -4.06593053245887E-09  -3.13118657208079E-18
      7.43320053839844E-08
      0.00000000000000E+00  -4.05990476352151E-12   0.00000000000000E+00   2.71609603175052E-15   1.23663308535115E-22
      4.05991435493232E-09   4.05991707102847E-09  -8.97237188444438E-19  -1.95542905104465E-01  -1.95542905104465E-01
      0.00000000000000E+00   0.00000000000000E+00   9.93378644647010E-14   0.00000000000000E+00   9.93378644647010E-14
      4.02877790109532E-18  -1.95542905158954E-01  -1.94263778860617E-01   0.00000000000000E+00  -2.58737477891343E-15
     -9.49454264416376E-23  -4.06001382151806E-09  -4.06001640889294E-09  -3.13154071265088E-18
      7.93320053839844E-08
      0.00000000000000E+00  -4.05586359508438E-12   0.00000000000000E+00   7.23563094956860E-17   1.23738178384299E-22
      4.05581941199319E-09   4.05581948434962E-09  -8.97336731439526E-19  -1.95489341173379E-01  -1.95489341173380E-01
      0.00000000000000E+00   0.00000000000000E+00   6.93173036607170E-14   0.00000000000000E+00   6.93173036607170E-14
      4.02912448761362E-18  -1.95489341242462E-01  -1.94211514522750E-01   0.00000000000000E+00   2.25932155126928E-17
     -9.50931284124797E-23  -4.05588882424640E-09  -4.05588880165328E-09  -3.13178775617410E-18
      8.43320053839844E-08
      0.00000000000000E+00  -4.05292456349374E-12   0.00000000000000E+00   6.29200977408463E-16   1.23736580856205E-22
      4.05296060075010E-09   4.05296122995120E-09  -8.97406239380718E-19  -1.95451941232591E-01  -1.95451941232591E-01
      0.00000000000000E+00   0.00000000000000E+00   4.83858583675741E-14   0.00000000000000E+00   4.83858583675741E-14
      4.02936641690546E-18  -1.95451941313632E-01  -1.94175021862303E-01   0.00000000000000E+00  -5.64618179236339E-16
     -9.32608591936330E-23  -4.05300905119130E-09  -4.05300961580957E-09  -3.13196017752474E-18
      8.93320053839844E-08
      0.00000000000000E+00  -4.05099582401238E-12   0.00000000000000E+00   6.85366464810347E-18   1.23776881763027E-22
      4.05096551390759E-09   4.05096552076137E-09  -8.97454784495656E-19  -1.95425822622050E-01  -1.95425822622050E-01
      0.00000000000000E+00   0.00000000000000E+00   3.37810154137665E-14   0.00000000000000E+00   3.37810154137665E-14
      4.02953532198253E-18  -1.95425822708945E-01  -1.94149536415111E-01   0.00000000000000E+00   3.94355662731621E-17
     -9.51886485180358E-23  -4.05099934121226E-09  -4.05099930177679E-09  -3.13208053748687E-18
      9.43320053839844E-08
      0.00000000000000E+00  -4.04952630821706E-12   0.00000000000000E+00   1.42321652341076E-16   1.23742482912206E-22
      4.04957229503085E-09   4.04957243735262E-09  -8.97488688022821E-19  -1.95407582110235E-01  -1.95407582110235E-01
      0.00000000000000E+00   0.00000000000000E+00   2.35884936510755E-14   0.00000000000000E+00   2.35884936510755E-14
      4.02965326445079E-18  -1.95407582193511E-01  -1.94131738047144E-01   0.00000000000000E+00  -1.10398691295448E-16
     -9.50485771093955E-23  -4.04959591544749E-09  -4.04959602584628E-09  -3.13216457642797E-18
      9.93320053839844E-08
      0.00000000000000E+00  -4.04860786084499E-12   0.00000000000000E+00   1.27915706717256E-16   1.23901690317051E-22
      4.04859951636960E-09   4.04859964428544E-09  -8.97512367880783E-19  -1.95394842457580E-01  -1.95394842457580E-01
      0.00000000000000E+00   0.00000000000000E+00   1.64727109953613E-14   0.00000000000000E+00   1.64727109953613E-14
      4.02973562800576E-18  -1.95394842525541E-01  -1.94119307096880E-01   0.00000000000000E+00  -1.06042427925986E-16
     -9.57769396589360E-23  -4.04861601095391E-09  -4.04861611699643E-09  -3.13222326012498E-18
      1.04332005383984E-07
      0.00000000000000E+00  -4.04796494768453E-12   0.00000000000000E+00   3.02752088480847E-17   1.23776147797721E-22
      4.04792018397243E-09   4.04792021424777E-09  -8.97528907558285E-19  -1.95385944382922E-01  -1.95385944382922E-01
      0.00000000000000E+00   0.00000000000000E+00   1.15044218016888E-14   0.00000000000000E+00   1.15044218016888E-14
      4.02979315011477E-18  -1.95385944420010E-01  -1.94110624581685E-01   0.00000000000000E+00  -1.48187847297163E-17
     -9.44777569231188E-23  -4.04793170385069E-09  -4.04793171866956E-09  -3.13226424255649E-18
      1.09332005383984E-07
      0.00000000000000E+00  -4.04750572399850E-12   0.00000000000000E+00   2.79825822913404E-17   1.23901665327870E-22
      4.04744571953424E-09   4.04744574751694E-09  -8.97540460134366E-19  -1.95379729383419E-01  -1.95379729383419E-01
      0.00000000000000E+00   0.00000000000000E+00   8.03494453888226E-15   0.00000000000000E+00   8.03494453888226E-15
      4.02983332483746E-18  -1.95379729372566E-01  -1.94104560108199E-01   0.00000000000000E+00  -1.71341851668324E-17
     -9.64227180743163E-23  -4.04745376532720E-09  -4.04745378246148E-09  -3.13229286470310E-18
      1.14332005383984E-07
      0.00000000000000E+00  -4.04713834504967E-12   0.00000000000000E+00   1.86444019184675E-16   1.23903856594527E-22
      4.04711429388154E-09   4.04711448032568E-09  -8.97548528864199E-19  -1.95375388563931E-01  -1.95375388563931E-01
      0.00000000000000E+00   0.00000000000000E+00   5.61200511286871E-15   0.00000000000000E+00   5.61200511286871E-15
      4.02986138486303E-18  -1.95375388485967E-01  -1.94100324401263E-01   0.00000000000000E+00  -1.79798551970143E-16
     -9.66518476853462E-23  -4.04711991253214E-09  -4.04712009233079E-09  -3.13231285599883E-18
      1.19332005383984E-07
      0.00000000000000E+00  -4.04686281083804E-12   0.00000000000000E+00   5.38643603034037E-18   1.23890656544998E-22
      4.04688290616341E-09   4.04688291154997E-09  -8.97554165426773E-19  -1.95372356320783E-01  -1.95372356320783E-01
      0.00000000000000E+00   0.00000000000000E+00   3.91974848398071E-15   0.00000000000000E+00   3.91974848398071E-15
      4.02988098360545E-18  -1.95372356158456E-01  -1.94097365506143E-01   0.00000000000000E+00  -3.50286603959377E-19
     -9.54928168919643E-23  -4.04688683094807E-09  -4.04688683129845E-09  -3.13232681817868E-18
      1.24332005383984E-07
      0.00000000000000E+00  -4.04667912136363E-12   0.00000000000000E+00   4.35414989301130E-17   1.23890883866417E-22
      4.04672122328200E-09   4.04672126682362E-09  -8.97558102367033E-19  -1.95370238396632E-01  -1.95370238396632E-01
      0.00000000000000E+00   0.00000000000000E+00   2.73783951456850E-15   0.00000000000000E+00   2.73783951456850E-15
      4.02989467280302E-18  -1.95370238137148E-01  -1.94095298795616E-01   0.00000000000000E+00  -4.00400987218878E-17
     -9.57704475949745E-23  -4.04672396462295E-09  -4.04672400466314E-09  -3.13233657043599E-18
      1.29332005383984E-07
      0.00000000000000E+00  -4.04658727662642E-12   0.00000000000000E+00   6.98135337407952E-19   1.23889091875942E-22
      4.04660831694654E-09   4.04660831764480E-09  -8.97560852421376E-19  -1.95368758989821E-01  -1.95368758989821E-01
      0.00000000000000E+00   0.00000000000000E+00   1.91234431558565E-15   0.00000000000000E+00   1.91234431558565E-15
      4.02990423452460E-18  -1.95368758626859E-01  -1.94093855116783E-01   0.00000000000000E+00   1.84321344939130E-18
     -9.63709956095842E-23  -4.04661023183223E-09  -4.04661022998911E-09  -3.13234338210323E-18
      1.34332005383984E-07
      0.00000000000000E+00  -4.04649543188921E-12   0.00000000000000E+00   9.95322131455797E-18   1.23828293850638E-22
      4.04652943778220E-09   4.04652944773554E-09  -8.97562773292163E-19  -1.95367725642440E-01  -1.95367725642440E-01
      0.00000000000000E+00   0.00000000000000E+00   1.33575606462815E-15   0.00000000000000E+00   1.33575606462815E-15
      4.02991091330493E-18  -1.95367725180899E-01  -1.94092846703493E-01   0.00000000000000E+00  -8.18125979737464E-18
     -9.03679282961060E-23  -4.04653077531026E-09  -4.04653078349161E-09  -3.13234814001276E-18
      1.39332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -1.22742116625640E-19   1.23876095673955E-22
      4.04647434656642E-09   4.04647434644381E-09  -8.97564115069119E-19  -1.95367003827594E-01  -1.95367003827594E-01
      0.00000000000000E+00   0.00000000000000E+00   9.33032084982946E-16   0.00000000000000E+00   9.33032084982946E-16
      4.02991557846535E-18  -1.95367003287109E-01  -1.94092142293183E-01   0.00000000000000E+00   1.37847312277099E-18
     -9.47344327827847E-23  -4.04647528085427E-09  -4.04647527947589E-09  -3.13235146339623E-18
      1.44332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   2.16899287082076E-18   1.23878114293903E-22
      4.04643585987387E-09   4.04643586204298E-09  -8.97565052341294E-19  -1.95366499618157E-01  -1.95366499618157E-01
      0.00000000000000E+00   0.00000000000000E+00   6.51753310634460E-16   0.00000000000000E+00   6.51753310634460E-16
      4.02991883723190E-18  -1.95366499037114E-01  -1.94091650257107E-01   0.00000000000000E+00  -1.29246960501153E-18
     -9.50484645400252E-23  -4.04643651250373E-09  -4.04643651379629E-09  -3.13235378489061E-18
      1.49332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -1.69326383830086E-19   1.23869870712869E-22
      4.04640897528883E-09   4.04640897511962E-09  -8.97565707113973E-19  -1.95366147382844E-01  -1.95366147382844E-01
      0.00000000000000E+00   0.00000000000000E+00   4.55309918047554E-16   0.00000000000000E+00   4.55309918047554E-16
      4.02992111378149E-18  -1.95366146820862E-01  -1.94091306572788E-01   0.00000000000000E+00   7.85373792948669E-19
     -9.44449019449186E-23  -4.04640943121482E-09  -4.04640943042954E-09  -3.13235540666752E-18
      1.54332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   4.25503047645062E-19   1.23875163574396E-22
      4.04639019103552E-09   4.04639019146114E-09  -8.97566164588311E-19  -1.95365901285391E-01  -1.95365901285391E-01
      0.00000000000000E+00   0.00000000000000E+00   3.18129243022881E-16   0.00000000000000E+00   3.18129243022881E-16
      4.02992270442771E-18  -1.95365900824268E-01  -1.94091066537424E-01   0.00000000000000E+00   1.25994744310158E-20
     -9.49865086682462E-23  -4.04639050960289E-09  -4.04639050959038E-09  -3.13235653983940E-18
      1.59332005383984E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -1.07431357099153E-19   1.23871178283334E-22
      4.04637706491849E-09   4.04637706481118E-09  -8.97566484288006E-19  -1.95365729304457E-01  -1.95365729304457E-01
      0.00000000000000E+00   0.00000000000000E+00   2.22346030226519E-16   0.00000000000000E+00   2.22346030226519E-16
      4.02992381615786E-18  -1.95365729046559E-01  -1.94090898925303E-01   0.00000000000000E+00   4.10577263169229E-19
     -9.44954695991624E-23  -4.04637728756769E-09  -4.04637728715721E-09  -3.13235733186986E-18
      1.64332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   5.05670672831398E-20   1.23871410260144E-22
      4.04636788942266E-09   4.04636788947335E-09  -8.97566707781550E-19  -1.95365609076844E-01  -1.95365609076844E-01
      0.00000000000000E+00   0.00000000000000E+00   1.55478342423680E-16   0.00000000000000E+00   1.55478342423680E-16
      4.02992459354957E-18  -1.95365609140196E-01  -1.94090781930766E-01   0.00000000000000E+00   1.58544339121583E-19
     -9.44528799144135E-23  -4.04636804511014E-09  -4.04636804495169E-09  -3.13235788576802E-18
      1.69332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -5.94315521787574E-20   1.23862923092763E-22
      4.04636147325294E-09   4.04636147319363E-09  -8.97566864095287E-19  -1.95365524986655E-01  -1.95365524986655E-01
      0.00000000000000E+00   0.00000000000000E+00   1.08801139445837E-16   0.00000000000000E+00   1.08801139445837E-16
      4.02992513755527E-18  -1.95365525495838E-01  -1.94090700322540E-01   0.00000000000000E+00   2.05899928072413E-19
     -9.37197880104747E-23  -4.04636158220058E-09  -4.04636158199477E-09  -3.13235827345998E-18
      1.74332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.21225991604294E-20   1.23866050947210E-22
      4.04635698454675E-09   4.04635698453475E-09  -8.97566973485791E-19  -1.95365466135563E-01  -1.95365466135563E-01
      0.00000000000000E+00   0.00000000000000E+00   7.62139505142741E-17   0.00000000000000E+00   7.62139505142741E-17
      4.02992551862502E-18  -1.95365467208037E-01  -1.94090643459182E-01   0.00000000000000E+00   1.12284694584555E-19
     -9.42182100007943E-23  -4.04635706086089E-09  -4.04635706074870E-09  -3.13235854513923E-18
      1.79332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -3.08034906327392E-20   1.23850399596168E-22
      4.04635384347459E-09   4.04635384344391E-09  -8.97567050076449E-19  -1.95365424924696E-01  -1.95365424924696E-01
      0.00000000000000E+00   0.00000000000000E+00   5.34471605995430E-17   0.00000000000000E+00   5.34471605995430E-17
      4.02992578586082E-18  -1.95365426652389E-01  -1.94090603900307E-01   0.00000000000000E+00   9.98617051530083E-20
     -9.20408128286356E-23  -4.04635389699084E-09  -4.04635389689107E-09  -3.13235873578437E-18
      1.84332005383984E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.54726136451720E-20   1.23837905545513E-22
      4.04635164615545E-09   4.04635164614010E-09  -8.97567103699197E-19  -1.95365396063994E-01  -1.95365396063994E-01
      0.00000000000000E+00   0.00000000000000E+00   3.75105854276533E-17   0.00000000000000E+00   3.75105854276533E-17
      4.02992597341375E-18  -1.95365398490633E-01  -1.94090576435842E-01   0.00000000000000E+00   6.31043604708193E-20
     -9.08473012201212E-23  -4.04635168371370E-09  -4.04635168365069E-09  -3.13235886971455E-18
      1.89332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.50163130506895E-20   1.23855431696256E-22
      4.04635011198064E-09   4.04635011196575E-09  -8.97567141181619E-19  -1.95365375879974E-01  -1.95365375879974E-01
      0.00000000000000E+00   0.00000000000000E+00   2.63074824116851E-17   0.00000000000000E+00   2.63074824116851E-17
      4.02992610495116E-18  -1.95365378975387E-01  -1.94090557407470E-01   0.00000000000000E+00   4.93065254605063E-20
     -9.29077085304232E-23  -4.04635013832245E-09  -4.04635013827323E-09  -3.13235896376954E-18
      1.94332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -8.65416598433308E-21   1.23856965725994E-22
      4.04634904644399E-09   4.04634904643546E-09  -8.97567167249388E-19  -1.95365361830507E-01  -1.95365361830507E-01
      0.00000000000000E+00   0.00000000000000E+00   1.83673968631695E-17   0.00000000000000E+00   1.83673968631695E-17
      4.02992619678815E-18  -1.95365365464022E-01  -1.94090544234306E-01   0.00000000000000E+00   3.08693295962718E-20
     -9.30356284368909E-23  -4.04634906483363E-09  -4.04634906480286E-09  -3.13235902953876E-18
      1.99332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -6.45999108160620E-21   1.23858488114334E-22
      4.04634831514284E-09   4.04634831513651E-09  -8.97567185160117E-19  -1.95365352164046E-01  -1.95365352164046E-01
      0.00000000000000E+00   0.00000000000000E+00   1.26601761768189E-17   0.00000000000000E+00   1.26601761768189E-17
      4.02992626008903E-18  -1.95365356080102E-01  -1.94090535082583E-01   0.00000000000000E+00   2.27084986234082E-20
     -9.32399634849070E-23  -4.04634832781930E-09  -4.04634832779668E-09  -3.13235907492891E-18
      2.04332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -5.52498635643919E-21   1.23860066336217E-22
      4.04634782532857E-09   4.04634782532317E-09  -8.97567197152541E-19  -1.95365345678223E-01  -1.95365345678223E-01
      0.00000000000000E+00   0.00000000000000E+00   8.46838595608671E-18   0.00000000000000E+00   8.46838595608671E-18
      4.02992630243096E-18  -1.95365349478342E-01  -1.94090528636460E-01   0.00000000000000E+00   1.65223793414964E-20
     -9.33743718420011E-23  -4.04634783380798E-09  -4.04634783379155E-09  -3.13235910527842E-18
      2.09332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -2.05655318034289E-21   1.23860414337552E-22
      4.04634751276817E-09   4.04634751276623E-09  -8.97567204767301E-19  -1.95365341547444E-01  -1.95365341547444E-01
      0.00000000000000E+00   0.00000000000000E+00   5.29950689545503E-18   0.00000000000000E+00   5.29950689545503E-18
      4.02992632892850E-18  -1.95365344683534E-01  -1.94090523941122E-01   0.00000000000000E+00   1.42203016929801E-20
     -9.29542529672493E-23  -4.04634751807987E-09  -4.04634751806574E-09  -3.13235912416119E-18
      2.14332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -2.71265674054566E-21   1.23864984565624E-22
      4.04634733225842E-09   4.04634733225583E-09  -8.97567209080098E-19  -1.95365339197568E-01  -1.95365339197568E-01
      0.00000000000000E+00   0.00000000000000E+00   2.82654214308452E-18   0.00000000000000E+00   2.82654214308452E-18
      4.02992634306120E-18  -1.95365340982167E-01  -1.94090520297404E-01   0.00000000000000E+00   1.44274200990929E-20
     -9.26725408434269E-23  -4.04634733509671E-09  -4.04634733508237E-09  -3.13235913398110E-18
      2.19332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -7.26514673980625E-22   1.23857429043672E-22
      4.04634725064347E-09   4.04634725064287E-09  -8.97567210873672E-19  -1.95365338213320E-01  -1.95365338213320E-01
      0.00000000000000E+00   0.00000000000000E+00   8.47485060467378E-19   0.00000000000000E+00   8.47485060467378E-19
      4.02992634729863E-18  -1.95365337852402E-01  -1.94090517193975E-01   0.00000000000000E+00   1.18043775033554E-20
     -9.30755215925018E-23  -4.04634725150206E-09  -4.04634725149035E-09  -3.13235913642496E-18
      2.24332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -3.51598353864758E-22   1.23855042392961E-22
      4.04634724167450E-09   4.04634724167427E-09  -8.97567210767209E-19  -1.95365338268454E-01  -1.95365338268454E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.42374228535772E-19   0.00000000000000E+00  -7.42374228535772E-19
      4.02992634358676E-18  -1.95365334921852E-01  -1.94090514266750E-01   0.00000000000000E+00   1.36304943113344E-20
     -9.28442895438689E-23  -4.04634724094544E-09  -4.04634724093190E-09  -3.13235913281955E-18
      2.29332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.60482473610572E-22   1.23889350652516E-22
      4.04634728216541E-09   4.04634728216537E-09  -8.97567209314010E-19  -1.95365339072730E-01  -1.95365339072730E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.97061671453320E-18   0.00000000000000E+00  -1.97061671453320E-18
      4.02992633373367E-18  -1.95365331945602E-01  -1.94090511278129E-01   0.00000000000000E+00   1.70422328243888E-20
     -9.60178629120904E-23  -4.04634728021170E-09  -4.04634728019475E-09  -3.13235912441966E-18
      2.34332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -5.54144609732232E-22   1.23908440200425E-22
      4.04634734923664E-09   4.04634734923621E-09  -8.97567207073968E-19  -1.95365340332185E-01  -1.95365340332185E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.80385502382567E-18   0.00000000000000E+00  -2.80385502382567E-18
      4.02992631971440E-18  -1.95365328798394E-01  -1.94090508110052E-01   0.00000000000000E+00   1.83818728462662E-20
     -9.79882161038920E-23  -4.04634734645064E-09  -4.04634734643236E-09  -3.13235911264043E-18
      2.39332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   3.55713289085542E-22   1.23912889935270E-22
      4.04634741850377E-09   4.04634741850425E-09  -8.97567204663026E-19  -1.95365341721500E-01  -1.95365341721500E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.16311648349192E-18   0.00000000000000E+00  -3.16311648349192E-18
      4.02992630389882E-18  -1.95365325475802E-01  -1.94090504765749E-01   0.00000000000000E+00   1.85213234287484E-20
     -9.50281357346951E-23  -4.04634741535955E-09  -4.04634741534112E-09  -3.13235909923579E-18
      2.44332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   1.07674138277179E-21   1.21835297176094E-22
      4.04634746321106E-09   4.04634746321225E-09  -8.97567202779535E-19  -1.95365342868548E-01  -1.95365342868548E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.94062995323825E-18   0.00000000000000E+00  -2.94062995323825E-18
      4.02992628919567E-18  -1.95365322099555E-01  -1.94090501375345E-01   0.00000000000000E+00   1.84861178718594E-20
     -2.22818362072089E-23  -4.04634746029009E-09  -4.04634746027163E-09  -3.13235908641613E-18
      2.49332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   3.47026203619443E-22   1.22783723273132E-22
      4.04634745436536E-09   4.04634745436583E-09  -8.97567202205043E-19  -1.95365343352394E-01  -1.95365343352394E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.01957432510463E-18   0.00000000000000E+00  -2.01957432510463E-18
      4.02992627909780E-18  -1.95365318922033E-01  -1.94090498200319E-01   0.00000000000000E+00   1.47767323778350E-20
     -8.83705056112932E-23  -4.04634745236094E-09  -4.04634745234626E-09  -3.13235907689275E-18
      2.54332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.18190083841404E-21   1.23336917935940E-22
      4.04634736191994E-09   4.04634736191888E-09  -8.97567203777178E-19  -1.95365342716407E-01  -1.95365342716407E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.98447332624619E-19   0.00000000000000E+00  -2.98447332624619E-19
      4.02992627760556E-18  -1.95365316325081E-01  -1.94090495631950E-01   0.00000000000000E+00   9.69341573509328E-21
     -1.89926782865231E-22  -4.04634736162994E-09  -4.04634736162044E-09  -3.13235907382838E-18
      2.59332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   2.96549664911160E-21  -3.55798637950125E-22
      4.04634715662857E-09   4.04634715663118E-09  -8.97567208338892E-19  -1.95365340498175E-01  -1.95365340498175E-01
      0.00000000000000E+00   0.00000000000000E+00   2.27478408352660E-18   0.00000000000000E+00   2.27478408352660E-18
      4.02992628897948E-18  -1.95365314810267E-01  -1.94090494181005E-01   0.00000000000000E+00  -5.93236494329680E-21
      1.63176180206209E-22  -4.04634715890020E-09  -4.04634715890597E-09  -3.13235908064058E-18
      2.64332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -4.50036748646400E-21   3.97365823914843E-21
      4.04634682043545E-09   4.04634682043492E-09  -8.97567216544947E-19  -1.95365336277156E-01  -1.95365336277156E-01
      0.00000000000000E+00   0.00000000000000E+00   5.76984665492797E-18   0.00000000000000E+00   5.76984665492797E-18
      4.02992631782871E-18  -1.95365314940225E-01  -1.94090494415785E-01   0.00000000000000E+00  -2.59263779660613E-20
      1.39509131566222E-21  -4.04634682618024E-09  -4.04634682620477E-09  -3.13235910128376E-18
      2.69332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   2.63303685895871E-18   1.28740301809365E-22
      4.04634633524829E-09   4.04634633788145E-09  -8.97567229113070E-19  -1.95365329737092E-01  -1.95365329737092E-01
      0.00000000000000E+00   0.00000000000000E+00   9.78481175050897E-18   0.00000000000000E+00   9.78481175050897E-18
      4.02992636675277E-18  -1.95365317338127E-01  -1.94090496965291E-01   0.00000000000000E+00  -2.67795000524849E-18
     -7.04807136397920E-23  -4.04634634498825E-09  -4.04634634766627E-09  -3.13235913763970E-18
      2.74332005383985E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   4.67671989357606E-18   1.21696717222007E-22
      4.04634573904368E-09   4.04634574372052E-09  -8.97567246081733E-19  -1.95365320740605E-01  -1.95365320740605E-01
      0.00000000000000E+00   0.00000000000000E+00   1.43189990646789E-17   0.00000000000000E+00   1.43189990646789E-17
      4.02992643834777E-18  -1.95365322417796E-01  -1.94090502231376E-01   0.00000000000000E+00  -4.59264216549993E-18
     -5.13365957738433E-23  -4.04634575344682E-09  -4.04634575803952E-09  -3.13235919226603E-18
      2.76832005383985E-07
      0.00000000000000E+00  -4.04612805294038E-12   0.00000000000000E+00  -4.98872480706004E-14   1.23661820078867E-22
      4.04604978412898E-09   4.04599989688103E-09  -8.97567018412285E-19  -1.95365323238895E-01  -1.95365323238895E-01
      0.00000000000000E+00   0.00000000000000E+00   2.34795584229946E-15   0.00000000000000E+00   2.34795584229946E-15
      4.02993230823737E-18  -1.95366036249978E-01  -1.94091308553190E-01   0.00000000000000E+00   4.99291544735020E-14
     -5.72914466536492E-23  -4.04605217399128E-09  -4.04600224483687E-09  -3.13236528982509E-18
      2.77675755383985E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   1.91022535234777E-17   1.23828963070512E-22
      4.04637682214446E-09   4.04637684124684E-09  -8.97567117467776E-19  -1.95365319719790E-01  -1.95365319719790E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23928304350207E-15   0.00000000000000E+00  -1.23928304350207E-15
      4.02993126259230E-18  -1.95366005887067E-01  -1.94091176297149E-01   0.00000000000000E+00  -2.18141686612536E-17
     -9.55355179456124E-23  -4.04637558014953E-09  -4.04637560196379E-09  -3.13236414512453E-18
      2.78814817883985E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -1.97880842901455E-17   1.23869310233320E-22
      4.04637117768767E-09   4.04637115789971E-09  -8.97567141135801E-19  -1.95365315998956E-01  -1.95365315998956E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.63928633897459E-16   0.00000000000000E+00  -7.63928633897459E-16
      4.02993039242984E-18  -1.95365971379969E-01  -1.94091143424263E-01   0.00000000000000E+00   1.73342304565157E-17
     -9.80601581829751E-23  -4.04637041130520E-09  -4.04637039397107E-09  -3.13236325129404E-18
      2.80352552258985E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -1.88497867023718E-19   1.23761187962058E-22
      4.04636531267613E-09   4.04636531248775E-09  -8.97567163364927E-19  -1.95365313124712E-01  -1.95365313124712E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.52027414869652E-16   0.00000000000000E+00  -5.52027414869652E-16
      4.02992954355831E-18  -1.95365934237298E-01  -1.94091108062687E-01   0.00000000000000E+00  -1.50031086807811E-18
     -9.57491474591722E-23  -4.04636475895993E-09  -4.04636476046034E-09  -3.13236238019338E-18
      2.82428493665235E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -1.15974419832525E-19   1.24089512786982E-22
      4.04636047639301E-09   4.04636047627716E-09  -8.97567176740982E-19  -1.95365314833039E-01  -1.95365314833039E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.72716686854914E-16   0.00000000000000E+00  -3.72716686854914E-16
      4.02992876982031E-18  -1.95365894717489E-01  -1.94091070010046E-01   0.00000000000000E+00  -7.19055668070417E-19
     -9.56805318636090E-23  -4.04636010284133E-09  -4.04636010356048E-09  -3.13236159307933E-18
      2.85231014563672E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -4.65600348081453E-20   1.23883844360568E-22
      4.04635780232314E-09   4.04635780227670E-09  -8.97567160220743E-19  -1.95365330864766E-01  -1.95365330864766E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.53415486282335E-16   0.00000000000000E+00  -2.53415486282335E-16
      4.02992805961811E-18  -1.95365849879490E-01  -1.94091025976929E-01   0.00000000000000E+00  -1.76316744340149E-19
     -9.55903298259398E-23  -4.04635754868481E-09  -4.04635754886122E-09  -3.13236089939737E-18
      2.89014417776563E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   2.12143199232392E-20   1.23888366459457E-22
      4.04635917836002E-09   4.04635917838135E-09  -8.97567067403495E-19  -1.95365384669913E-01  -1.95365384669913E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.15009675698758E-16   0.00000000000000E+00  -2.15009675698758E-16
      4.02992724614982E-18  -1.95365786521220E-01  -1.94090962173001E-01   0.00000000000000E+00   2.92628131645753E-19
     -9.59049632282009E-23  -4.04635896366421E-09  -4.04635896337168E-09  -3.13236017874632E-18
      2.94014417776563E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   9.41497178515357E-20   1.23891294709819E-22
      4.04636764227999E-09   4.04636764237426E-09  -8.97566811426232E-19  -1.95365522824378E-01  -1.95365522824378E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.67711614727630E-16   0.00000000000000E+00  -2.67711614727630E-16
      4.02992590759174E-18  -1.95365667058409E-01  -1.94090840060126E-01   0.00000000000000E+00   7.97244466630581E-19
     -9.64959299335335E-23  -4.04636737545980E-09  -4.04636737466265E-09  -3.13235909616551E-18
      2.99014417776563E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   1.47337084440266E-19   1.23874694616870E-22
      4.04638157360640E-09   4.04638157375386E-09  -8.97566422111874E-19  -1.95365731712809E-01  -1.95365731712809E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.68366948537161E-16   0.00000000000000E+00  -3.68366948537161E-16
      4.02992406575700E-18  -1.95365487930365E-01  -1.94090656574564E-01   0.00000000000000E+00   1.31656758009449E-18
     -9.51334509745650E-23  -4.04638120670338E-09  -4.04638120538691E-09  -3.13235764364512E-18
      3.04014417776563E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   1.89990216863789E-19   1.23852457402269E-22
      4.04639977636135E-09   4.04639977655146E-09  -8.97565914345325E-19  -1.95366005969479E-01  -1.95366005969479E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.83445406746466E-16   0.00000000000000E+00  -4.83445406746466E-16
      4.02992164852997E-18  -1.95365231863097E-01  -1.94090394808558E-01   0.00000000000000E+00   1.85515041925177E-18
     -9.35716832440787E-23  -4.04639929496111E-09  -4.04639929310606E-09  -3.13235573418464E-18
      3.09014417776563E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   2.13182448983152E-19   1.23842078787176E-22
      4.04642057389688E-09   4.04642057411018E-09  -8.97565322340979E-19  -1.95366329261874E-01  -1.95366329261874E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.86476034760301E-16   0.00000000000000E+00  -5.86476034760301E-16
      4.02991871614979E-18  -1.95364890212848E-01  -1.94090046638252E-01   0.00000000000000E+00   2.36971803924553E-18
     -9.27773298003520E-23  -4.04641999000377E-09  -4.04641998763415E-09  -3.13235339380882E-18
      3.14014417776563E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   2.23325764302384E-19   1.23841208698900E-22
      4.04644157241281E-09   4.04644157263626E-09  -8.97564703047166E-19  -1.95366672626235E-01  -1.95366672626235E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.51894675117789E-16   0.00000000000000E+00  -6.51894675117789E-16
      4.02991545667642E-18  -1.95364465943209E-01  -1.94089615773371E-01   0.00000000000000E+00   2.77136360691053E-18
     -9.27244346897733E-23  -4.04644092351286E-09  -4.04644092074159E-09  -3.13235075362925E-18
      3.19014417776563E-07
      0.00000000000000E+00  -4.04649543188921E-12   0.00000000000000E+00   1.85354970945088E-19   1.23841897680651E-22
      4.04645956709830E-09   4.04645956728378E-09  -8.97564137969048E-19  -1.95366993453573E-01  -1.95366993453573E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.53190247765109E-16   0.00000000000000E+00  -6.53190247765109E-16
      4.02991219072518E-18  -1.95363976896811E-01  -1.94089121057897E-01   0.00000000000000E+00   2.99842024581309E-18
     -9.27576714245043E-23  -4.04645891709186E-09  -4.04645891409353E-09  -3.13234805275613E-18
      3.24014417776563E-07
      0.00000000000000E+00  -4.04649543188921E-12   0.00000000000000E+00   1.54173820702086E-19   1.23841282470192E-22
      4.04647057314535E-09   4.04647057329965E-09  -8.97563732658920E-19  -1.95367235608610E-01  -1.95367235608610E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.63444110746282E-16   0.00000000000000E+00  -5.63444110746282E-16
      4.02990937350462E-18  -1.95363458770093E-01  -1.94088599435245E-01   0.00000000000000E+00   2.86946732029422E-18
     -9.27270296803858E-23  -4.04647001272491E-09  -4.04647000985554E-09  -3.13234564084570E-18
      3.29014417776563E-07
      0.00000000000000E+00  -4.04649543188921E-12   0.00000000000000E+00   6.56944835847905E-20   1.23841950503996E-22
      4.04646999343015E-09   4.04646999349597E-09  -8.97563612991198E-19  -1.95367331209282E-01  -1.95367331209282E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.57494752091637E-16   0.00000000000000E+00  -3.57494752091637E-16
      4.02990758603086E-18  -1.95362967160712E-01  -1.94088107943519E-01   0.00000000000000E+00   2.32416799242657E-18
     -9.27948647550480E-23  -4.04646963832529E-09  -4.04646963600121E-09  -3.13234397303967E-18
      3.34014417776563E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00   4.87052877032474E-19   1.23841487494684E-22
      4.04645294454082E-09   4.04645294502800E-09  -8.97563917319003E-19  -1.95367204591756E-01  -1.95367204591756E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53885170557007E-17   0.00000000000000E+00  -1.53885170557007E-17
      4.02990750908828E-18  -1.95362577995846E-01  -1.94087724042189E-01   0.00000000000000E+00   6.67234002759963E-19
     -9.27988393143214E-23  -4.04645293030663E-09  -4.04645292963949E-09  -3.13234359176927E-18
      3.39014417776563E-07
      0.00000000000000E+00  -4.04640358715201E-12   0.00000000000000E+00  -1.05198776134365E-19   1.23840719740414E-22
      4.04641475939445E-09   4.04641475928938E-09  -8.97564783826025E-19  -1.95366778873951E-01  -1.95366778873951E-01
      0.00000000000000E+00   0.00000000000000E+00   4.73144567558536E-16   0.00000000000000E+00   4.73144567558536E-16
      4.02990987481111E-18  -1.95362385583115E-01  -1.94087543506056E-01   0.00000000000000E+00  -6.20147256243557E-19
     -9.27944778154344E-23  -4.04641523181370E-09  -4.04641523243394E-09  -3.13234509098509E-18
      3.44014417776563E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   1.62772297896431E-18   1.23839815164263E-22
      4.04635167095779E-09   4.04635167258564E-09  -8.97566332617178E-19  -1.95365985401719E-01  -1.95365985401719E-01
      0.00000000000000E+00   0.00000000000000E+00   1.10345954859756E-15   0.00000000000000E+00   1.10345954859756E-15
      4.02991539210886E-18  -1.95362497549975E-01  -1.94087675150907E-01   0.00000000000000E+00  -4.99434991440827E-18
     -9.27954296196698E-23  -4.04635277105074E-09  -4.04635277604519E-09  -3.13234905949168E-18
      3.49014417776563E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00  -3.83186882694618E-19   1.23838189199952E-22
      4.04626166792429E-09   4.04626166754122E-09  -8.97568642829867E-19  -1.95364775994012E-01  -1.95364775994012E-01
      0.00000000000000E+00   0.00000000000000E+00   1.85050366880850E-15   0.00000000000000E+00   1.85050366880850E-15
      4.02992464462720E-18  -1.95363026005482E-01  -1.94088231727387E-01   0.00000000000000E+00  -6.15997892731426E-18
     -9.27531646252714E-23  -4.04626351188482E-09  -4.04626351804489E-09  -3.13235600179734E-18
      3.54014417776563E-07
      0.00000000000000E+00  -4.04612805294038E-12   0.00000000000000E+00   2.58186581062816E-18   1.23836599439189E-22
      4.04614546675716E-09   4.04614546933915E-09  -8.97571725496319E-19  -1.95363137627525E-01  -1.95363137627525E-01
      0.00000000000000E+00   0.00000000000000E+00   2.66368526905899E-15   0.00000000000000E+00   2.66368526905899E-15
      4.02993796305355E-18  -1.95364074554236E-01  -1.94089316630331E-01   0.00000000000000E+00  -1.29800785060368E-17
     -9.27203906517318E-23  -4.04614812004425E-09  -4.04614813302442E-09  -3.13236623755723E-18
      3.59014417776563E-07
      0.00000000000000E+00  -4.04603620820318E-12   0.00000000000000E+00  -9.50443504900366E-19   1.23834713863701E-22
      4.04600754601915E-09   4.04600754506883E-09  -8.97575494223036E-19  -1.95361108546800E-01  -1.95361108546800E-01
      0.00000000000000E+00   0.00000000000000E+00   3.46291899501037E-15   0.00000000000000E+00   3.46291899501037E-15
      4.02995527764852E-18  -1.95365721065117E-01  -1.94091006342861E-01   0.00000000000000E+00  -1.31916446999083E-17
     -9.26609580018951E-23  -4.04601099479609E-09  -4.04601100798782E-09  -3.13237978342549E-18
      3.64014417776563E-07
      0.00000000000000E+00  -4.04585251872876E-12   0.00000000000000E+00   1.01960322115608E-18   1.23834466158587E-22
      4.04585709311198E-09   4.04585709413170E-09  -8.97579736348899E-19  -1.95358794371813E-01  -1.95358794371813E-01
      0.00000000000000E+00   0.00000000000000E+00   4.13700970257641E-15   0.00000000000000E+00   4.13700970257641E-15
      4.02997596269704E-18  -1.95367996786927E-01  -1.94093329254241E-01   0.00000000000000E+00  -1.90311163522409E-17
     -9.27118187965695E-23  -4.04586121211020E-09  -4.04586123114141E-09  -3.13239622634814E-18
      3.69014417776563E-07
      0.00000000000000E+00  -4.04566882925435E-12   0.00000000000000E+00  -1.48671192160346E-18   1.23835193485565E-22
      4.04570875256127E-09   4.04570875107468E-09  -8.97584088868788E-19  -1.95356381992022E-01  -1.95356381992022E-01
      0.00000000000000E+00   0.00000000000000E+00   4.54527478003459E-15   0.00000000000000E+00   4.54527478003459E-15
      4.02999868907094E-18  -1.95370862934191E-01  -1.94096242009437E-01   0.00000000000000E+00  -1.90855208252250E-17
     -9.28073981127339E-23  -4.04571327726385E-09  -4.04571329634946E-09  -3.13241460020215E-18
      3.74014417776563E-07
      0.00000000000000E+00  -4.04557698451714E-12   0.00000000000000E+00  -1.30176478646026E-18   1.23835486146390E-22
      4.04558294085444E-09   4.04558293955280E-09  -8.97588024049727E-19  -1.95354148553034E-01  -1.95354148553033E-01
      0.00000000000000E+00   0.00000000000000E+00   4.52396947079223E-15   0.00000000000000E+00   4.52396947079223E-15
      4.03002130891829E-18  -1.95374186847996E-01  -1.94099605568700E-01   0.00000000000000E+00  -2.06527391683479E-17
     -9.28190906578621E-23  -4.04558744286944E-09  -4.04558746352227E-09  -3.13243328486856E-18
      3.79014417776563E-07
      0.00000000000000E+00  -4.04557698451714E-12   0.00000000000000E+00   2.01268797088933E-19   1.23836852790299E-22
      4.04550555341778E-09   4.04550555361917E-09  -8.97590850834428E-19  -1.95352462275983E-01  -1.95352462275983E-01
      0.00000000000000E+00   0.00000000000000E+00   3.89816747373774E-15   0.00000000000000E+00   3.89816747373774E-15
      4.03004079975566E-18  -1.95377720657130E-01  -1.94103163957310E-01   0.00000000000000E+00  -2.09134934689885E-17
     -9.28438476265293E-23  -4.04550943087306E-09  -4.04550945178664E-09  -3.13244994892123E-18
      3.84014417776563E-07
      0.00000000000000E+00  -4.04548513977993E-12   0.00000000000000E+00   1.12786140590560E-17   1.23839124485221E-22
      4.04550682224601E-09   4.04550683352474E-09  -8.97591738147398E-19  -1.95351771704110E-01  -1.95351771704110E-01
      0.00000000000000E+00   0.00000000000000E+00   2.50014731465715E-15   0.00000000000000E+00   2.50014731465715E-15
      4.03005330049223E-18  -1.95381086238561E-01  -1.94106529580147E-01   0.00000000000000E+00  -2.77520855665933E-17
     -9.28521780720874E-23  -4.04550930591988E-09  -4.04550933367206E-09  -3.13246156234483E-18
      3.89014417776563E-07
      0.00000000000000E+00  -4.04566882925435E-12   0.00000000000000E+00   8.16724432801265E-18   1.23842472598173E-22
      4.04561913725887E-09   4.04561914542624E-09  -8.97589766693007E-19  -1.95352579742248E-01  -1.95352579742248E-01
      0.00000000000000E+00   0.00000000000000E+00   1.94561987870121E-16   0.00000000000000E+00   1.94561987870121E-16
      4.03005427330217E-18  -1.95383771099641E-01  -1.94109179782381E-01   0.00000000000000E+00  -1.65603588219392E-17
     -9.28430699145947E-23  -4.04561932342778E-09  -4.04561933998823E-09  -3.13246450660916E-18
      3.94014417776563E-07
      0.00000000000000E+00  -4.04585251872876E-12   0.00000000000000E+00   6.43859575025475E-17   1.23847354697328E-22
      4.04587365496582E-09   4.04587371935190E-09  -8.97584012854835E-19  -1.95355400215227E-01  -1.95355400215227E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.09063912249475E-15   0.00000000000000E+00  -3.09063912249475E-15
      4.03003882010656E-18  -1.95385140323037E-01  -1.94110469853112E-01   0.00000000000000E+00  -6.11518977773913E-17
     -9.28452096266822E-23  -4.04587056756079E-09  -4.04587062871278E-09  -3.13245480725172E-18
      3.99014417776563E-07
      0.00000000000000E+00  -4.04631174241480E-12   0.00000000000000E+00   2.29503996625123E-17   1.23853445062221E-22
      4.04629577194143E-09   4.04629579489195E-09  -8.97573669609255E-19  -1.95360694304800E-01  -1.95360694304800E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.32834552363460E-15   0.00000000000000E+00  -7.32834552363460E-15
      4.03000217837894E-18  -1.95384469162242E-01  -1.94109667035777E-01   0.00000000000000E+00  -1.98654990236691E-18
     -9.28387008877559E-23  -4.04628846455978E-09  -4.04628846654643E-09  -3.13242850876969E-18
      4.04014417776563E-07
      0.00000000000000E+00  -4.04686281083804E-12   0.00000000000000E+00   1.49988814078287E-16   1.23860658444168E-22
      4.04689922111853E-09   4.04689937110746E-09  -8.97558199238200E-19  -1.95368788730502E-01  -1.95368788730502E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23547042083894E-14   0.00000000000000E+00  -1.23547042083894E-14
      4.02994040485790E-18  -1.95381001836318E-01  -1.94106011170876E-01   0.00000000000000E+00  -1.12047984764839E-16
     -9.28371867856656E-23  -4.04688690435518E-09  -4.04688701640326E-09  -3.13238220561970E-18
      4.09014417776563E-07
      0.00000000000000E+00  -4.04768941347291E-12   0.00000000000000E+00   3.27344002099108E-17   1.23868408405070E-22
      4.04767976217202E-09   4.04767979490655E-09  -8.97537517628307E-19  -1.95379776426393E-01  -1.95379776426393E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.78352387445211E-14   0.00000000000000E+00  -1.78352387445211E-14
      4.02985122866417E-18  -1.95374037106005E-01  -1.94098802249764E-01   0.00000000000000E+00   3.36243477660553E-17
     -9.28355259275328E-23  -4.04766199329206E-09  -4.04766195966780E-09  -3.13231371103587E-18
      4.14014417776563E-07
      0.00000000000000E+00  -4.04860786084499E-12   0.00000000000000E+00   1.74019417612952E-16   1.23875889877383E-22
      4.04860779942604E-09   4.04860797344558E-09  -8.97512190311836E-19  -1.95393408401879E-01  -1.95393408401879E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.32355617197058E-14   0.00000000000000E+00  -2.32355617197058E-14
      4.02973505085558E-18  -1.95363044625234E-01  -1.94087519081952E-01   0.00000000000000E+00  -9.10427698469947E-17
     -9.28329852008535E-23  -4.04858464684100E-09  -4.04858473788386E-09  -3.13222286054374E-18
      4.19014417776563E-07
      0.00000000000000E+00  -4.04961815295427E-12   0.00000000000000E+00   2.05831327530133E-17   1.23882022753755E-22
      4.04962241365405E-09   4.04962243423731E-09  -8.97483628648686E-19  -1.95408984752146E-01  -1.95408984752146E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.78138515047851E-14   0.00000000000000E+00  -2.78138515047851E-14
      4.02959598159805E-18  -1.95347803712469E-01  -1.94071959945677E-01   0.00000000000000E+00   9.61115603111920E-17
     -9.28311576196659E-23  -4.04959471649727E-09  -4.04959462038580E-09  -3.13211235294937E-18
      4.24014417776563E-07
      0.00000000000000E+00  -4.05062844506355E-12   0.00000000000000E+00   5.27089550756613E-17   1.23885413470088E-22
      4.05062569762023E-09   4.05062575032931E-09  -8.97454252377869E-19  -1.95425260317570E-01  -1.95425260317570E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.06254160234673E-14   0.00000000000000E+00  -3.06254160234673E-14
      4.02944285451794E-18  -1.95328562588823E-01  -1.94052403610484E-01   0.00000000000000E+00   7.38373848704671E-17
     -9.28280207155551E-23  -4.05059519875058E-09  -4.05059512491329E-09  -3.13198860214007E-18
      4.29014417776563E-07
      0.00000000000000E+00  -4.05145504769842E-12   0.00000000000000E+00   1.35426125542542E-17   1.23884498177090E-22
      4.05148092307358E-09   4.05148093661632E-09  -8.97427589162744E-19  -1.95440383113729E-01  -1.95440383113729E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.05709515149595E-14   0.00000000000000E+00  -3.05709515149595E-14
      4.02928999976036E-18  -1.95306198533717E-01  -1.94029770087514E-01   0.00000000000000E+00   1.32568368413456E-16
     -9.28248543078300E-23  -4.05145049823308E-09  -4.05145036566481E-09  -3.13186241059761E-18
      4.34014417776563E-07
      0.00000000000000E+00  -4.05200611612166E-12   0.00000000000000E+00   1.04007004023571E-17   1.21527990199365E-22
      4.05201411894961E-09   4.05201412935043E-09  -8.97408268934985E-19  -1.95451886499965E-01  -1.95451886499965E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.64698784787825E-14   0.00000000000000E+00  -2.64698784787825E-14
      4.02915765036797E-18  -1.95282363597020E-01  -1.94005765865755E-01   0.00000000000000E+00   1.29539246178746E-16
     -9.48320276255085E-23  -4.05198778901110E-09  -4.05198765947195E-09  -3.13174938143298E-18
      4.39014417776563E-07
      0.00000000000000E+00  -4.05209796085887E-12   0.00000000000000E+00   1.40789179596528E-16   1.23865799760725E-22
      4.05202173288534E-09   4.05202187367464E-09  -8.97401870947706E-19  -1.95456759539498E-01  -1.95456759539498E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.71874351355218E-14   0.00000000000000E+00  -1.71874351355218E-14
      4.02907171319229E-18  -1.95259587565986E-01  -1.93982984506597E-01   0.00000000000000E+00  -2.95989457630203E-17
     -9.31503738732838E-23  -4.05200465664047E-09  -4.05200468623951E-09  -3.13166984224458E-18
      4.44014417776563E-07
      0.00000000000000E+00  -4.05127135822401E-12   0.00000000000000E+00   5.91193127230644E-17   1.21477346575904E-22
      4.05128532849778E-09   4.05128538761721E-09  -8.97414587248384E-19  -1.95451615847387E-01  -1.95451615847387E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.79931656962626E-15   0.00000000000000E+00  -1.79931656962626E-15
      4.02906271660944E-18  -1.95241307357640E-01  -1.93964931456851E-01   0.00000000000000E+00  -2.34529452706510E-18
     -9.47776762645557E-23  -4.05128358595526E-09  -4.05128358830064E-09  -3.13164812936105E-18
      4.49014417776563E-07
      0.00000000000000E+00  -4.04961815295427E-12   0.00000000000000E+00   5.46515491942783E-16   1.23807323911107E-22
      4.04959396711023E-09   4.04959451362585E-09  -8.97452658043752E-19  -1.95432985284227E-01  -1.95432985284227E-01
      0.00000000000000E+00   0.00000000000000E+00   2.01969441072471E-14   0.00000000000000E+00   2.01969441072471E-14
      4.02916370132998E-18  -1.95231790222873E-01  -1.93955940267776E-01   0.00000000000000E+00  -5.86821539385205E-16
     -9.30103232167757E-23  -4.04961412374832E-09  -4.04961471056995E-09  -3.13171104328622E-18
      4.54014417776563E-07
      0.00000000000000E+00  -4.04677096610084E-12   0.00000000000000E+00   2.02001309966821E-16   1.23214592505987E-22
      4.04677605796205E-09   4.04677625996349E-09  -8.97521579631542E-19  -1.95397732714922E-01  -1.95397732714922E-01
      0.00000000000000E+00   0.00000000000000E+00   4.86389899546912E-14   0.00000000000000E+00   4.86389899546912E-14
      4.02940689627975E-18  -1.95235911348022E-01  -1.93960940239621E-01   0.00000000000000E+00  -3.48623286333538E-16
     -9.41513059496357E-23  -4.04682455033006E-09  -4.04682489895344E-09  -3.13188531664821E-18
      4.56514417776563E-07
      0.00000000000000E+00  -4.04502591609389E-12   0.00000000000000E+00  -3.49749874669929E-17   1.24124726424224E-22
      4.04506783192817E-09   4.04506779695331E-09  -8.97564367604822E-19  -1.95375594083601E-01  -1.95375594083601E-01
      0.00000000000000E+00   0.00000000000000E+00   6.44035444681582E-14   0.00000000000000E+00   6.44035444681582E-14
      4.02956790514092E-18  -1.95242018795606E-01  -1.93967580912620E-01   0.00000000000000E+00  -1.73878715632948E-16
     -1.05349159046612E-22  -4.04513202661896E-09  -4.04513220049778E-09  -3.13200353753610E-18
      4.57358167776563E-07
      0.00000000000000E+00  -4.04447484767065E-12   0.00000000000000E+00  -3.91507876090575E-17   1.23746173389655E-22
      4.04445660296391E-09   4.04445656381325E-09  -8.97579779595698E-19  -1.95367595119394E-01  -1.95367595119394E-01
      0.00000000000000E+00   0.00000000000000E+00   6.98962212435628E-14   0.00000000000000E+00   6.98962212435628E-14
      4.02962688007759E-18  -1.95244565833296E-01  -1.93970318793259E-01   0.00000000000000E+00  -1.92890244893538E-16
     -9.60800108194265E-23  -4.04452626714415E-09  -4.04452646003449E-09  -3.13204710048190E-18
      4.58497230276563E-07
      0.00000000000000E+00  -4.04355640029857E-12   0.00000000000000E+00  -3.93669149800137E-17   1.16692294823466E-22
      4.04356668599549E-09   4.04356664662869E-09  -8.97602406327243E-19  -1.95355805582808E-01  -1.95355805582808E-01
      0.00000000000000E+00   0.00000000000000E+00   7.76149057033659E-14   0.00000000000000E+00   7.76149057033659E-14
      4.02971528830612E-18  -1.95248951707429E-01  -1.93974982612417E-01   0.00000000000000E+00  -2.25479046350532E-16
     -9.00919707245773E-23  -4.04364403605526E-09  -4.04364426153440E-09  -3.13211288197888E-18
      4.60034964651563E-07
      0.00000000000000E+00  -4.04227057397767E-12   0.00000000000000E+00  -3.83995888103325E-17   1.23816144681578E-22
      4.04224471374872E-09   4.04224467534925E-09  -8.97636377754542E-19  -1.95338018226411E-01  -1.95338018226412E-01
      0.00000000000000E+00   0.00000000000000E+00   8.85531707280403E-14   0.00000000000000E+00   8.85531707280403E-14
      4.02985145956077E-18  -1.95256753475719E-01  -1.93983197434787E-01   0.00000000000000E+00  -2.73805557009996E-16
     -1.01380016435133E-22  -4.04233295471432E-09  -4.04233322851998E-09  -3.13221508180623E-18
      4.62110906057813E-07
      0.00000000000000E+00  -4.04024998975910E-12   0.00000000000000E+00  -3.15339016931589E-17   1.24193051558156E-22
      4.04023678331034E-09   4.04023675177657E-09  -8.97688673888697E-19  -1.95310470133909E-01  -1.95310470133909E-01
      0.00000000000000E+00   0.00000000000000E+00   1.04145439146217E-13   0.00000000000000E+00   1.04145439146217E-13
      4.03006765939016E-18  -1.95271092771776E-01  -1.93998164437014E-01   0.00000000000000E+00  -3.49942752656888E-16
     -9.81850654439160E-23  -4.04034054727286E-09  -4.04034089721571E-09  -3.13237898550147E-18
      4.64913426956250E-07
      0.00000000000000E+00  -4.03712726869405E-12   0.00000000000000E+00   1.38281209335379E-18   1.22495403707583E-22
      4.03712328786498E-09   4.03712328924791E-09  -8.97771160297764E-19  -1.95266692800254E-01  -1.95266692800254E-01
      0.00000000000000E+00   0.00000000000000E+00   1.26287380600921E-13   0.00000000000000E+00   1.26287380600921E-13
      4.03042158241351E-18  -1.95298286052133E-01  -1.94026331680393E-01   0.00000000000000E+00  -4.85851189756658E-16
     -9.44925070558576E-23  -4.03724909077723E-09  -4.03724957662851E-09  -3.13265042211574E-18
      4.68696830169141E-07
      0.00000000000000E+00  -4.03225949762205E-12   0.00000000000000E+00   1.00275569792204E-16   1.22153768725579E-22
      4.03225060213696E-09   4.03225070241265E-09  -8.97903176972855E-19  -1.95195962122711E-01  -1.95195962122711E-01
      0.00000000000000E+00   0.00000000000000E+00   1.56698127996010E-13   0.00000000000000E+00   1.56698127996010E-13
      4.03101443461442E-18  -1.95351174752193E-01  -1.94080745991594E-01   0.00000000000000E+00  -7.39518919958428E-16
     -9.66885846064955E-23  -4.03240666102163E-09  -4.03240740054064E-09  -3.13311125764156E-18
      4.73696830169141E-07
      0.00000000000000E+00  -4.02500376338265E-12   0.00000000000000E+00  -5.76183370643406E-17   1.19131976136284E-22
      4.02500613012569E-09   4.02500607250747E-09  -8.98105691126244E-19  -1.95086074747055E-01  -1.95086074747055E-01
      0.00000000000000E+00   0.00000000000000E+00   1.92869780695862E-13   0.00000000000000E+00   1.92869780695862E-13
      4.03197878351790E-18  -1.95451798382357E-01  -1.94183640679332E-01   0.00000000000000E+00  -7.55151831362341E-16
     -9.09795626161189E-23  -4.02519818713624E-09  -4.02519894228817E-09  -3.13387309239166E-18
      4.78696830169141E-07
      0.00000000000000E+00  -4.01756433966884E-12   0.00000000000000E+00  -7.52898491006580E-17   1.23835393195210E-22
      4.01757768904940E-09   4.01757761375967E-09  -8.98321175260271E-19  -1.94967461846313E-01  -1.94967461846313E-01
      0.00000000000000E+00   0.00000000000000E+00   2.18586720059747E-13   0.00000000000000E+00   2.18586720059747E-13
      4.03307171711820E-18  -1.95582600376217E-01  -1.94316774991544E-01   0.00000000000000E+00  -8.93926177735084E-16
     -1.06905989545632E-22  -4.01779530655345E-09  -4.01779620047973E-09  -3.13475054185792E-18
      4.81196830169141E-07
      0.00000000000000E+00  -4.01389055018054E-12   0.00000000000000E+00  -7.42808560113612E-17   1.23626108542650E-22
      4.01391322080024E-09   4.01391314651951E-09  -8.98429798634476E-19  -1.94907193583396E-01  -1.94907193583396E-01
      0.00000000000000E+00   0.00000000000000E+00   2.27921357013660E-13   0.00000000000000E+00   2.27921357013660E-13
      4.03364152051073E-18  -1.95655249294408E-01  -1.94390575505767E-01   0.00000000000000E+00  -9.62914875454164E-16
     -9.59677410757546E-23  -4.01414010496155E-09  -4.01414106787653E-09  -3.13521172187625E-18
      4.84571830169141E-07
      0.00000000000000E+00  -4.00939015805737E-12   0.00000000000000E+00  -6.86217588867114E-17   1.23503160762042E-22
      4.00934507049069E-09   4.00934500186905E-09  -8.98570511730451E-19  -1.94828013773365E-01  -1.94828013773366E-01
      0.00000000000000E+00   0.00000000000000E+00   2.31681214623158E-13   0.00000000000000E+00   2.31681214623158E-13
      4.03442344461009E-18  -1.95764902780182E-01  -1.94501667064320E-01   0.00000000000000E+00  -1.02916026793796E-15
     -9.56813556195684E-23  -4.00957565392331E-09  -4.00957668308368E-09  -3.13585293287963E-18
      4.89128080169141E-07
      0.00000000000000E+00  -4.00479792119700E-12   0.00000000000000E+00  -1.65591910947665E-17   1.23417370168451E-22
      4.00478287507541E-09   4.00478285851635E-09  -8.98725280223010E-19  -1.94738015014242E-01  -1.94738015014242E-01
      0.00000000000000E+00   0.00000000000000E+00   2.14002088157188E-13   0.00000000000000E+00   2.14002088157188E-13
      4.03539849162425E-18  -1.95926269689585E-01  -1.94664476935564E-01   0.00000000000000E+00  -1.07710711318485E-15
     -9.51464424315183E-23  -4.00499578349730E-09  -4.00499686060451E-09  -3.13667321140124E-18
      4.94128080169141E-07
      0.00000000000000E+00  -4.00314471592726E-12   0.00000000000000E+00   1.50564220558306E-16   1.23595488926721E-22
      4.00316127503543E-09   4.00316142559978E-09  -8.98812783108956E-19  -1.94681033497083E-01  -1.94681033497083E-01
      0.00000000000000E+00   0.00000000000000E+00   1.58451546787729E-13   0.00000000000000E+00   1.58451546787729E-13
      4.03619074935819E-18  -1.96102817186563E-01  -1.94841552869659E-01   0.00000000000000E+00  -1.09390567737685E-15
     -9.53289846379050E-23  -4.00331878324080E-09  -4.00331987714657E-09  -3.13737796624923E-18
      4.99128080169141E-07
      0.00000000000000E+00  -4.00654297120394E-12   0.00000000000000E+00   4.17774529023203E-16   1.23757127511715E-22
      4.00653296117791E-09   4.00653337895256E-09  -8.98772422414693E-19  -1.94690581098717E-01  -1.94690581098717E-01
      0.00000000000000E+00   0.00000000000000E+00   5.91961389034705E-14   0.00000000000000E+00   5.91961389034705E-14
      4.03648673005271E-18  -1.96255462676734E-01  -1.94993167384462E-01   0.00000000000000E+00  -1.02477762051829E-15
     -9.57012175234141E-23  -4.00659155031375E-09  -4.00659257509147E-09  -3.13771430763801E-18
      5.04128080169141E-07
      0.00000000000000E+00  -4.01655404755956E-12   0.00000000000000E+00   1.00468565740639E-16   1.24010841188145E-22
      4.01652426536067E-09   4.01652436582936E-09  -8.98556924876052E-19  -1.94792770827807E-01  -1.94792770827807E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.86816791857343E-14   0.00000000000000E+00  -8.86816791857343E-14
      4.03604332165678E-18  -1.96354293727655E-01  -1.95088897201205E-01   0.00000000000000E+00  -1.46677817866523E-16
     -9.57169107567306E-23  -4.01643553747226E-09  -4.01643568415017E-09  -3.13748639678073E-18
      5.09128080169141E-07
      0.00000000000000E+00  -4.03455561605224E-12   0.00000000000000E+00   1.81402570178945E-16   1.24361909120896E-22
      4.03458076333132E-09   4.03458094473401E-09  -8.98122870739807E-19  -1.95012174219498E-01  -1.95012174219497E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.85782690473210E-13   0.00000000000000E+00  -2.85782690473210E-13
      4.03461440820441E-18  -1.96363998392451E-01  -1.95092975113631E-01   0.00000000000000E+00   5.65867539408333E-16
     -9.57027654577392E-23  -4.03429572791098E-09  -4.03429516204354E-09  -3.13649153746461E-18
      5.14128080169141E-07
      0.00000000000000E+00  -4.06174165826566E-12   0.00000000000000E+00   3.14361383946496E-15   1.24498090511987E-22
      4.06170808905651E-09   4.06171123267048E-09  -8.97438022738495E-19  -1.95367955151597E-01  -1.95367955151597E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.26597690527351E-13   0.00000000000000E+00  -5.26597690527351E-13
      4.03198141975178E-18  -1.96246172794533E-01  -1.94966678666589E-01   0.00000000000000E+00  -1.41360397849756E-15
     -9.57468049883929E-23  -4.06118322137587E-09  -4.06118463497995E-09  -3.13454339701328E-18
      5.19128080169141E-07
      0.00000000000000E+00  -4.09811217419984E-12   0.00000000000000E+00   2.17056733634207E-14   1.24859057442249E-22
      4.09815130165785E-09   4.09817300733134E-09  -8.96489985362619E-19  -1.95869219513491E-01  -1.95869219513491E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.97805698709803E-13   0.00000000000000E+00  -7.97805698709803E-13
      4.02799239125823E-18  -1.95963025097615E-01  -1.94672134606481E-01   0.00000000000000E+00  -1.90396179547159E-14
     -9.56434718437336E-23  -4.09735616201458E-09  -4.09737520163263E-09  -3.13150240589561E-18
      5.24128080169141E-07
      0.00000000000000E+00  -4.14302425069432E-12   0.00000000000000E+00   3.50688396018736E-15   1.25305253861771E-22
      4.14307148417243E-09   4.14307499105652E-09  -8.95295813968342E-19  -1.96509744966895E-01  -1.96509744966893E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07656433349422E-12   0.00000000000000E+00  -1.07656433349422E-12
      4.02260956959076E-18  -1.95482422140119E-01  -1.94177466887324E-01   0.00000000000000E+00   7.02884672191724E-16
     -9.55127914089238E-23  -4.14199912960760E-09  -4.14199842672302E-09  -3.12731375562241E-18
      5.29128080169141E-07
      0.00000000000000E+00  -4.19408992458171E-12   0.00000000000000E+00   1.96184597408526E-14   1.24618891992390E-22
      4.19405814974966E-09   4.19407776820952E-09  -8.93910820663230E-19  -1.97262994454091E-01  -1.97262994454090E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.33029163176178E-12   0.00000000000000E+00  -1.33029163176178E-12
      4.01595811143195E-18  -1.94784998926374E-01  -1.93464059669019E-01   0.00000000000000E+00  -1.45667811543011E-14
     -9.53679004207550E-23  -4.19273290979651E-09  -4.19274747657776E-09  -3.12204729076872E-18
      5.34128080169141E-07
      0.00000000000000E+00  -4.24699249321324E-12   0.00000000000000E+00   1.24618753682084E-15   1.25884629519633E-22
      4.24694372470061E-09   4.24694497088828E-09  -8.92436758095605E-19  -1.98077257618520E-01  -1.98077257618518E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.51537760150454E-12   0.00000000000000E+00  -1.51537760150454E-12
      4.00838122342442E-18  -1.93871800210311E-01  -1.92534257010219E-01   0.00000000000000E+00   5.30587717631627E-15
     -9.52631384659969E-23  -4.24543489916385E-09  -4.24542959328677E-09  -3.11594446532882E-18
      5.39128080169140E-07
      0.00000000000000E+00  -4.29539466972161E-12   0.00000000000000E+00   2.85246396354893E-15   1.25889823169775E-22
      4.29533573099875E-09   4.29533858346284E-09  -8.91027280299427E-19  -1.98872257655125E-01  -1.98872257655124E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.57968634214749E-12   0.00000000000000E+00  -1.57968634214749E-12
      4.00048279171369E-18  -1.92773781262923E-01  -1.91421011758430E-01   0.00000000000000E+00   3.96193331168638E-15
     -9.50949321938932E-23  -4.29376285905391E-09  -4.29375889712070E-09  -3.10945551141426E-18
      5.44128080169140E-07
      0.00000000000000E+00  -4.33075489354651E-12   0.00000000000000E+00   3.42703566951947E-15   1.25660927363468E-22
      4.33077127139379E-09   4.33077469842958E-09  -8.89889745998819E-19  -1.99537426486147E-01  -1.99537426486146E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.46332587425133E-12   0.00000000000000E+00  -1.46332587425133E-12
      3.99316616234243E-18  -1.91560137307625E-01  -1.90196166591987E-01   0.00000000000000E+00   3.74432888473272E-15
     -9.49039621412526E-23  -4.32931511688412E-09  -4.32931137255533E-09  -3.10327641634361E-18
      5.49128080169140E-07
      0.00000000000000E+00  -4.34287839885790E-12   0.00000000000000E+00   3.88595443094811E-14   1.25039434484693E-22
      4.34284198574421E-09   4.34288084528865E-09  -8.89282453328701E-19  -1.99932978504617E-01  -1.99932978504616E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10500408535650E-12   0.00000000000000E+00  -1.10500408535650E-12
      3.98764114191565E-18  -1.90345669874358E-01  -1.88977783011259E-01   0.00000000000000E+00  -3.30364241971815E-14
     -9.47944974763466E-23  -4.34174280477900E-09  -4.34177584120329E-09  -3.09835868858695E-18
      5.54128080169140E-07
      0.00000000000000E+00  -4.32010090403044E-12   0.00000000000000E+00   3.05954003895733E-14   1.24060692395563E-22
      4.32007430915551E-09   4.32010490455602E-09  -8.89506993511185E-19  -1.99893765190641E-01  -1.99893765190640E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.47484634308366E-13   0.00000000000000E+00  -4.47484634308366E-13
      3.98540371874411E-18  -1.89293681314034E-01  -1.87932760224401E-01   0.00000000000000E+00  -2.67726598514476E-14
     -9.46707387709910E-23  -4.31963064726176E-09  -4.31965741992171E-09  -3.09589672523292E-18
      5.59128080169140E-07
      0.00000000000000E+00  -4.25130919586200E-12   0.00000000000000E+00  -6.90274883904185E-16   1.22742067862453E-22
      4.25128941679478E-09   4.25128872652002E-09  -8.90889297640615E-19  -1.99239406815153E-01  -1.99239406815153E-01
      0.00000000000000E+00   0.00000000000000E+00   5.50201726780979E-13   0.00000000000000E+00   5.50201726780979E-13
      3.98815472737801E-18  -1.88612340073915E-01  -1.87272775820225E-01   0.00000000000000E+00   1.15304657613565E-15
     -9.46516991274855E-23  -4.25184008129328E-09  -4.25183892824680E-09  -3.09726542973740E-18
      5.64128080169140E-07
      0.00000000000000E+00  -4.12750249010625E-12   0.00000000000000E+00   9.78222998751974E-14   1.20647885599389E-22
      4.12755822098709E-09   4.12765604328709E-09  -8.93752407327215E-19  -1.97789773781275E-01  -1.97789773781276E-01
      0.00000000000000E+00   0.00000000000000E+00   1.89847792990059E-12   0.00000000000000E+00   1.89847792990059E-12
      3.99764711702751E-18  -1.88542044755224E-01  -1.87241038305288E-01   0.00000000000000E+00  -1.03566824617792E-13
     -9.47572234569926E-23  -4.12945095439227E-09  -4.12955452121699E-09  -3.10389470970030E-18
      5.69128080169140E-07
      0.00000000000000E+00  -3.94500699727490E-12   0.00000000000000E+00  -1.84282566841204E-15   1.18558075730029E-22
      3.94494183112579E-09   3.94493998830024E-09  -8.98375778550981E-19  -1.95388278943666E-01  -1.95388278943670E-01
      0.00000000000000E+00   0.00000000000000E+00   3.56091277561146E-12   0.00000000000000E+00   3.56091277561146E-12
      4.01545168090557E-18  -1.89330480092846E-01  -1.88086484978392E-01   0.00000000000000E+00  -9.68928641680226E-15
     -9.50045914050438E-23  -3.94849121178934E-09  -3.94850090107586E-09  -3.11707590235459E-18
      5.74128080169140E-07
      0.00000000000000E+00  -3.70639437000974E-12   0.00000000000000E+00   1.61554167555736E-13   1.15594513992156E-22
      3.70639796986786E-09   3.70655952403553E-09  -9.04931249111328E-19  -1.91937699724571E-01  -1.91937699724577E-01
      0.00000000000000E+00   0.00000000000000E+00   5.43220600453699E-12   0.00000000000000E+00   5.43220600453699E-12
      4.04261271092826E-18  -1.91199939693260E-01  -1.90030510637901E-01   0.00000000000000E+00  -1.83674769996993E-13
     -9.54422840964484E-23  -3.71180805526997E-09  -3.71199173004007E-09  -3.13768146181693E-18
      5.79128080169140E-07
      0.00000000000000E+00  -3.42452287151984E-12   0.00000000000000E+00  -2.80832180615300E-15   1.12667421972689E-22
      3.42450801957691E-09   3.42450521125522E-09  -9.13406230084204E-19  -1.87442606600649E-01  -1.87442606600656E-01
      0.00000000000000E+00   0.00000000000000E+00   7.33107491668262E-12   0.00000000000000E+00   7.33107491668262E-12
      4.07926808551167E-18  -1.94303332808438E-01  -1.93222117868477E-01   0.00000000000000E+00  -2.65077672020621E-14
     -9.60756349661902E-23  -3.43180977840460E-09  -3.43183628617189E-09  -3.16586185542747E-18
      5.84128080169140E-07
      0.00000000000000E+00  -3.12042494662572E-12   0.00000000000000E+00  -3.09179032060480E-15   1.09724892709445E-22
      3.12044376827957E-09   3.12044067648936E-09  -9.23501759606068E-19  -1.82062784728724E-01  -1.82062784728733E-01
      0.00000000000000E+00   0.00000000000000E+00   8.99184818393963E-12   0.00000000000000E+00   8.99184818393963E-12
      4.12422732643137E-18  -1.98687251574992E-01  -1.97701311956880E-01   0.00000000000000E+00  -3.60715530485552E-14
     -9.69101570295747E-23  -3.12939645312015E-09  -3.12943252467329E-09  -3.20072556682530E-18
      5.89128080169140E-07
      0.00000000000000E+00  -2.82330722175937E-12   0.00000000000000E+00  -3.03332486560173E-15   1.06970877293417E-22
      2.82328086613837E-09   2.82327783281362E-09  -9.34526741151253E-19  -1.76163833261459E-01  -1.76163833261469E-01
      0.00000000000000E+00   0.00000000000000E+00   1.00909198235005E-11   0.00000000000000E+00   1.00909198235005E-11
      4.17468192554887E-18  -2.04259979605467E-01  -2.03367317913567E-01   0.00000000000000E+00  -4.51017140165189E-14
     -9.77999147751557E-23  -2.83332365092300E-09  -2.83336875263711E-09  -3.24015518439761E-18
      5.94128080169140E-07
      0.00000000000000E+00  -2.56614195757830E-12   0.00000000000000E+00  -2.63668862712977E-15   1.05474573486615E-22
      2.56619291953118E-09   2.56619028284266E-09  -9.45306296307207E-19  -1.70354801581538E-01  -1.70354801581548E-01
      0.00000000000000E+00   0.00000000000000E+00   1.02822656421404E-11   0.00000000000000E+00   1.02822656421404E-11
      4.22609325375957E-18  -2.10778953053489E-01  -2.09967229275386E-01   0.00000000000000E+00  -5.17099609246093E-14
     -1.00901461403538E-22  -2.57642083852377E-09  -2.57647254848480E-09  -3.28078695745236E-18
      5.99128080169140E-07
      0.00000000000000E+00  -2.38337093053532E-12   0.00000000000000E+00  -1.88482413110167E-15   1.05705621225895E-22
      2.38334803142653E-09   2.38334614660251E-09  -9.54159208629427E-19  -1.65488467066566E-01  -1.65488467066576E-01
      0.00000000000000E+00   0.00000000000000E+00   9.25139701868426E-12   0.00000000000000E+00   9.25139701868426E-12
      4.27235023885299E-18  -2.17853334416210E-01  -2.17099542757557E-01   0.00000000000000E+00  -5.35156011451097E-14
     -1.00058105915110E-22  -2.39254402801995E-09  -2.39259754362119E-09  -3.31819103022357E-18
      6.04128080169140E-07
      0.00000000000000E+00  -2.30897669339722E-12   0.00000000000000E+00  -7.78778421869944E-16   1.08786803372474E-22
      2.30900170178784E-09   2.30900092300953E-09  -9.59030091782783E-19  -1.62592771964444E-01  -1.62592771964450E-01
      0.00000000000000E+00   0.00000000000000E+00   6.77322343397106E-12   0.00000000000000E+00   6.77322343397106E-12
      4.30621635602285E-18  -2.24950555285278E-01  -2.24220968566636E-01   0.00000000000000E+00  -4.80852043217716E-14
     -1.00961239452630E-22  -2.31572606123908E-09  -2.31577414644350E-09  -3.34718626424007E-18
      6.09128080169140E-07
      0.00000000000000E+00  -2.38043189894468E-12   0.00000000000000E+00   7.37243472341801E-16   1.15275280511823E-22
      2.38040586359638E-09   2.38040660083996E-09  -9.57862549724022E-19  -1.62705157138161E-01  -1.62705157138164E-01
      0.00000000000000E+00   0.00000000000000E+00   2.77128130146285E-12   0.00000000000000E+00   2.77128130146285E-12
      4.32007276253016E-18  -2.31388529335139E-01  -2.30637708166830E-01   0.00000000000000E+00  -3.38545185755882E-14
     -1.02062824612050E-22  -2.38314402762275E-09  -2.38317788214142E-09  -3.36221021280614E-18
      6.14128080169140E-07
      0.00000000000000E+00  -2.64338338156983E-12   0.00000000000000E+00   6.67814730765651E-16   1.25171374192645E-22
      2.64340096901656E-09   2.64340163683142E-09  -9.49202716067815E-19  -1.66616570680498E-01  -1.66616570680496E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.62779182061441E-12   0.00000000000000E+00  -2.62779182061441E-12
      4.30693380342709E-18  -2.36301417451934E-01  -2.35469440307283E-01   0.00000000000000E+00  -8.97923741652693E-15
     -1.01736380313858E-22  -2.64076486577328E-09  -2.64077384501080E-09  -3.35773108735927E-18
      6.19128080169140E-07
      0.00000000000000E+00  -3.15514225729017E-12   0.00000000000000E+00   5.20156682109709E-15   1.37418951170656E-22
      3.15515620908449E-09   3.15516141065145E-09  -9.32812599548336E-19  -1.74601981691939E-01  -1.74601981691930E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.05914671014217E-12   0.00000000000000E+00  -9.05914671014217E-12
      4.26163806987638E-18  -2.38593605357748E-01  -2.37602424042894E-01   0.00000000000000E+00   1.81313313215086E-14
     -1.01336749130926E-22  -3.14612039527253E-09  -3.14610226394131E-09  -3.32882547032804E-18
      6.24128080169140E-07
      0.00000000000000E+00  -3.97458100265572E-12   0.00000000000000E+00   8.29262894127611E-15   1.49892028797095E-22
      3.97456179746931E-09   3.97457009009840E-09  -9.09899046267592E-19  -1.86275787419455E-01  -1.86275787419439E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.59310091971848E-11   0.00000000000000E+00  -1.59310091971848E-11
      4.18198302389045E-18  -2.36940926712213E-01  -2.35693752037392E-01   0.00000000000000E+00   4.99026249397617E-14
     -1.00335764997739E-22  -3.95868898352606E-09  -3.95863908090122E-09  -3.27208397762286E-18
      6.29128080169140E-07
      0.00000000000000E+00  -5.13448818884958E-12   0.00000000000000E+00   1.21634936308064E-14   1.60155111299279E-22
      5.13453287673596E-09   5.13454504022975E-09  -8.82697776438571E-19  -2.00689355941976E-01  -2.00689355941954E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.25274762257505E-11   0.00000000000000E+00  -2.25274762257505E-11
      4.06934564276170E-18  -2.29922607993273E-01  -2.28312053367836E-01   0.00000000000000E+00   8.00238944878185E-14
     -9.83424580268338E-23  -5.11209758789839E-09  -5.11201756400400E-09  -3.18664786632313E-18
      6.34128080169140E-07
      0.00000000000000E+00  -6.60804515260713E-12   0.00000000000000E+00   1.49473236077100E-14   1.65973157878398E-22
      6.60805672645837E-09   6.60807167378215E-09  -8.53620235845061E-19  -2.16658211658955E-01  -2.16658211658927E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.82598959191153E-11   0.00000000000000E+00  -2.82598959191153E-11
      3.92804616316613E-18  -2.16307727013559E-01  -2.14234728503876E-01   0.00000000000000E+00   1.05433315951222E-13
     -9.61393125784052E-23  -6.57991721117889E-09  -6.57981177786303E-09  -3.07442592732107E-18
      6.39128080169140E-07
      0.00000000000000E+00  -8.29293685667921E-12   0.00000000000000E+00   3.05308122867925E-14   1.65330850106451E-22
      8.29289419627611E-09   8.29292472708856E-09  -8.24523508824831E-19  -2.33139823393387E-01  -2.33139823393354E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.29531541222771E-11   0.00000000000000E+00  -3.29531541222771E-11
      3.76328039255474E-18  -1.95401241171651E-01  -1.92798888759548E-01   0.00000000000000E+00   1.07849274885531E-13
     -9.29789352311243E-23  -8.26007942224108E-09  -8.25997157296629E-09  -2.93875688372991E-18
      6.44128080169139E-07
      0.00000000000000E+00  -1.00296289925363E-11   0.00000000000000E+00   1.73861137800155E-14   1.56445204861275E-22
      1.00295924744083E-08   1.00296098605222E-08  -7.96462161640948E-19  -2.49443731055909E-01  -2.49443731055872E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.67611538186423E-11   0.00000000000000E+00  -3.67611538186423E-11
      3.57947462346153E-18  -1.67289034147725E-01  -1.64140702711518E-01   0.00000000000000E+00   1.26021757788170E-13
     -8.93947281353778E-23  -9.99297472846124E-09  -9.99284870670354E-09  -2.78301246182058E-18
      6.49128080169139E-07
      0.00000000000000E+00  -1.16432491805354E-11   0.00000000000000E+00   1.61258107114102E-14   1.38589452747330E-22
      1.16432168159732E-08   1.16432329417841E-08  -7.69816884227946E-19  -2.65220575631243E-01  -2.65220575631203E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.96862757069186E-11   0.00000000000000E+00  -3.96862757069186E-11
      3.38104324492694E-18  -1.32875410817233E-01  -1.29219592024039E-01   0.00000000000000E+00   1.21618254887390E-13
     -8.59007330832652E-23  -1.16036682843320E-08  -1.16035466660772E-08  -2.61122636069899E-18
      6.54128080169139E-07
      0.00000000000000E+00  -1.28805814801952E-11   0.00000000000000E+00   1.67709341485538E-14   1.10260480552144E-22
      1.28805485210364E-08   1.28805652919707E-08  -7.44703556387839E-19  -2.80322979214953E-01  -2.80322979214912E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.17308292034577E-11   0.00000000000000E+00  -4.17308292034577E-11
      3.17238909890965E-18  -9.42237376507160E-02  -9.01787058864416E-02   0.00000000000000E+00   1.08036168895285E-13
     -8.04083831543921E-23  -1.28389424989360E-08  -1.28388344627672E-08  -2.42768554252181E-18
      6.59128080169139E-07
      0.00000000000000E+00  -1.29555267857565E-11   0.00000000000000E+00   8.78762397750888E-16   7.10850528133322E-23
      1.29554779675810E-08   1.29554788463435E-08  -7.21041833118203E-19  -2.94686940544580E-01  -2.94686940544538E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.19426474913828E-11   0.00000000000000E+00  -4.19426474913828E-11
      2.96267586145273E-18  -5.70331488046698E-02  -5.29645597660311E-02   0.00000000000000E+00   9.92764663699616E-14
     -6.29777931889868E-23  -1.29136354753184E-08  -1.29135361988521E-08  -2.24163402833453E-18
      6.64128080169139E-07
      0.00000000000000E+00  -1.09791198857877E-11   0.00000000000000E+00  -1.93395642938195E-14   3.69249631996709E-23
      1.09791317912255E-08   1.09791124516613E-08  -6.97145386987496E-19  -3.08271737440057E-01  -3.08271737440021E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.58031389563868E-11   0.00000000000000E+00  -3.58031389563868E-11
      2.78366016667080E-18  -3.09370521257374E-02  -2.74891989524883E-02   0.00000000000000E+00   8.40899056453387E-14
     -3.61019162037725E-23  -1.09433934026105E-08  -1.09433093127049E-08  -2.08651477968330E-18
      6.69128080169139E-07
      0.00000000000000E+00  -8.52971258920022E-12   0.00000000000000E+00  -2.40031811473096E-14   1.92789327473325E-23
      8.52971992205098E-09   8.52969591886985E-09  -6.72004061320837E-19  -3.20952506707313E-01  -3.20952506707286E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.62635436707467E-11   0.00000000000000E+00  -2.62635436707467E-11
      2.65234244831707E-18  -1.76414589256260E-02  -1.49623201401227E-02   0.00000000000000E+00   6.12196589679877E-14
     -1.96364463402960E-23  -8.50349359485805E-09  -8.50343237519910E-09  -1.98033838699623E-18
      6.74128080169139E-07
      0.00000000000000E+00  -7.07617777815390E-12   0.00000000000000E+00  -1.41893286423267E-14   1.17090589952653E-23
      7.07616381687893E-09   7.07614962755030E-09  -6.47276632693188E-19  -3.32416737097959E-01  -3.32416737097940E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.93268140030311E-11   0.00000000000000E+00  -1.93268140030311E-11
      2.55570837830191E-18  -1.18302184732085E-02  -9.60685378046843E-03   0.00000000000000E+00   3.71434050460946E-14
     -1.28473631557010E-23  -7.05685995695230E-09  -7.05682281354727E-09  -1.90843174560872E-18
      6.79128080169139E-07
      0.00000000000000E+00  -6.44437783090332E-12   0.00000000000000E+00  -6.10834362559110E-15   8.35539368129189E-24
      6.44441477396007E-09   6.44440866561646E-09  -6.25391900401264E-19  -3.42102241630349E-01  -3.42102241630335E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.46536042548370E-11   0.00000000000000E+00  -1.46536042548370E-11
      2.48244035702773E-18  -9.26317370934639E-03  -7.23737498952221E-03   0.00000000000000E+00   2.16571264563736E-14
     -1.00378895012663E-23  -6.42977671848807E-09  -6.42975506136163E-09  -1.85704845662646E-18
      6.84128080169139E-07
      0.00000000000000E+00  -6.18004867722006E-12   0.00000000000000E+00  -2.52051902586099E-15   6.69432942987567E-24
      6.18005229308965E-09   6.18004977257063E-09  -6.09051529033730E-19  -3.49153687304033E-01  -3.49153687304023E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02312180729955E-11   0.00000000000000E+00  -1.02312180729955E-11
      2.43128426666275E-18  -8.04696226789795E-03  -6.10305967182857E-03   0.00000000000000E+00   1.26402732218334E-14
     -8.83785577701690E-24  -6.16983119477085E-09  -6.16981855449764E-09  -1.82223273762902E-18
      6.89128080169139E-07
      0.00000000000000E+00  -6.03925069508092E-12   0.00000000000000E+00  -1.34852936738279E-15   5.85641757252752E-24
      6.03925438244082E-09   6.03925303391146E-09  -6.01294655309285E-19  -3.52466191479650E-01  -3.52466191479646E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.79068565403614E-12   0.00000000000000E+00  -4.79068565403614E-12
      2.40733083839257E-18  -7.52787052035123E-03  -5.62661363034924E-03   0.00000000000000E+00   5.88105769884031E-15
     -8.57763216637557E-24  -6.03446822931512E-09  -6.03446234825742E-09  -1.80603618308328E-18
      6.94128080169139E-07
      0.00000000000000E+00  -5.92380186041106E-12   0.00000000000000E+00  -1.12364110456798E-15   5.56818926328764E-24
      5.92381582041337E-09   5.92381469677227E-09  -6.05233935622505E-19  -3.50816121546491E-01  -3.50816121546494E-01
      0.00000000000000E+00   0.00000000000000E+00   2.18937634567951E-12   0.00000000000000E+00   2.18937634567951E-12
      2.41827772012097E-18  -7.54599682781328E-03  -5.67891172002410E-03   0.00000000000000E+00  -1.00331381115818E-15
     -9.22684314147721E-24  -5.92600306980412E-09  -5.92600407311794E-09  -1.81304378449846E-18
      6.99128080169139E-07
      0.00000000000000E+00  -5.78217727563705E-12   0.00000000000000E+00  -1.49236900835365E-15   5.78026821045255E-24
      5.78215761163887E-09   5.78215611926987E-09  -6.23568419997270E-19  -3.43005954958134E-01  -3.43005954958145E-01
      0.00000000000000E+00   0.00000000000000E+00   1.07816954299257E-11   0.00000000000000E+00   1.07816954299257E-11
      2.47218619727059E-18  -8.19295773961845E-03  -6.36779837519918E-03   0.00000000000000E+00  -9.07362874234274E-15
     -1.12036915401438E-23  -5.79292874107104E-09  -5.79293781469979E-09  -1.84861777727333E-18
      7.04128080169139E-07
      0.00000000000000E+00  -5.55201436419499E-12   0.00000000000000E+00  -2.34285284703871E-15   6.57989434113047E-24
      5.55197583771524E-09   5.55197349486240E-09  -6.57946364623445E-19  -3.27989892641833E-01  -3.27989892641854E-01
      0.00000000000000E+00   0.00000000000000E+00   2.09561390972873E-11   0.00000000000000E+00   2.09561390972873E-11
      2.57696689275703E-18  -9.85142070719915E-03  -8.09558059518438E-03   0.00000000000000E+00  -1.94476486289569E-14
     -1.56254730643502E-23  -5.57291018631105E-09  -5.57292963395969E-09  -1.91902052813359E-18
      7.09128080169139E-07
      0.00000000000000E+00  -5.11529263877320E-12   0.00000000000000E+00   6.82277691779710E-14   8.15371942778039E-24
      5.11527954084909E-09   5.11534776861827E-09  -7.08268486943674E-19  -3.04970438675374E-01  -3.04970438675407E-01
      0.00000000000000E+00   0.00000000000000E+00   3.30982245729840E-11   0.00000000000000E+00   3.30982245729840E-11
      2.74245801562195E-18  -1.34435417731851E-02  -1.18214682377502E-02   0.00000000000000E+00  -1.06446948247748E-13
     -2.47987644622801E-23  -5.14833954624298E-09  -5.14844599319125E-09  -2.03418952867828E-18
      7.14128080169139E-07
      0.00000000000000E+00  -4.27573989595920E-12   0.00000000000000E+00  -8.35477974917986E-15   1.04461874933271E-23
      4.27572648947383E-09   4.27571813469409E-09  -7.72562511773654E-19  -2.73523272304526E-01  -2.73523272304574E-01
      0.00000000000000E+00   0.00000000000000E+00   4.80035103358465E-11   0.00000000000000E+00   4.80035103358465E-11
      2.98247556730118E-18  -2.07748357317470E-02  -1.94125854750546E-02   0.00000000000000E+00  -5.19099109823468E-14
     -4.16862801453949E-23  -4.32366973511891E-09  -4.32372164502994E-09  -2.20991305552753E-18
      7.19128080169139E-07
      0.00000000000000E+00  -2.92819391165037E-12   0.00000000000000E+00  -1.39027014400465E-14   1.14609417619482E-23
      2.92825928789609E-09   2.92824538519467E-09  -8.48649748713405E-19  -2.33881653532332E-01  -2.33881653532396E-01
      0.00000000000000E+00   0.00000000000000E+00   6.43981199399958E-11   0.00000000000000E+00   6.43981199399958E-11
      3.30446616700116E-18  -3.40683576764074E-02  -3.31254868600593E-02   0.00000000000000E+00  -7.95465373500878E-14
     -6.44669265984587E-23  -2.99256395859725E-09  -2.99264350513466E-09  -2.45581641828776E-18
      7.24128080169139E-07
      0.00000000000000E+00  -1.49798766385476E-12   0.00000000000000E+00  -1.48866572199375E-14   5.71890013652628E-24
      1.49802628929944E-09   1.49801140264223E-09  -9.36295804091784E-19  -1.87396766326488E-01  -1.87396766326564E-01
      0.00000000000000E+00   0.00000000000000E+00   7.62325016244206E-11   0.00000000000000E+00   7.62325016244206E-11
      3.68562867512327E-18  -5.34521439620177E-02  -5.29561613690879E-02   0.00000000000000E+00  -1.23083232815959E-13
     -8.20732507783599E-23  -1.57412082103375E-09  -1.57424390426665E-09  -2.74933287103148E-18
      7.29128080169139E-07
      0.00000000000000E+00  -5.76417570714438E-13   0.00000000000000E+00  -2.14953041027033E-14  -8.70692055448241E-24
      5.76451473545148E-10   5.76429978241037E-10  -1.03616802489816E-18  -1.36452083969691E-01  -1.36452083969770E-01
      0.00000000000000E+00   0.00000000000000E+00   7.88755041948959E-11   0.00000000000000E+00   7.88755041948959E-11
      4.08000619609774E-18  -7.62647310017086E-02  -7.60582679950883E-02   0.00000000000000E+00  -1.72366469204832E-13
     -9.04972991589233E-23  -6.55133115966637E-10  -6.55305482435933E-10  -3.04383817119958E-18
      7.34128080169139E-07
      0.00000000000000E+00  -1.77719566496564E-13   0.00000000000000E+00  -5.14484237584003E-15  -2.42914850718334E-23
      1.77757106100294E-10   1.77751961257894E-10  -1.14368491847541E-18  -8.49671984239586E-02  -8.49671984240310E-02
      0.00000000000000E+00   0.00000000000000E+00   7.24094068280895E-11   0.00000000000000E+00   7.24094068280895E-11
      4.44205323023819E-18  -9.99040033627248E-02  -9.98251886110946E-02   0.00000000000000E+00  -2.55936676270671E-13
     -9.62240638368821E-23  -2.49905431409617E-10  -2.50161368085984E-10  -3.29836831176278E-18
      7.39128080169139E-07
      0.00000000000000E+00  -6.04338370825526E-14   0.00000000000000E+00  -2.25024222088361E-15  -3.15927826196132E-23
      6.04665148765533E-11   6.04642646343009E-11  -1.23370178198121E-18  -4.36966921000675E-02  -4.36966921001230E-02
      0.00000000000000E+00   0.00000000000000E+00   5.55122924223578E-11   0.00000000000000E+00   5.55122924223578E-11
      4.71961469234998E-18  -1.23043207981570E-01  -1.23006669144786E-01   0.00000000000000E+00  -2.85143544429217E-13
     -1.01696757246399E-22  -1.15691413512127E-10  -1.15976557056658E-10  -3.48591291036877E-18
      7.44128080169139E-07
      0.00000000000000E+00  -4.10545975317645E-14   0.00000000000000E+00  -7.71288301955806E-16  -2.88441174215812E-23
      4.10472278072682E-11   4.10464565189374E-11  -1.28346499735075E-18  -2.16460209416983E-02  -2.16460209417322E-02
      0.00000000000000E+00   0.00000000000000E+00   3.38196775021727E-11   0.00000000000000E+00   3.38196775021727E-11
      4.88871307986085E-18  -1.45262727072180E-01  -1.45239140397651E-01   0.00000000000000E+00  -2.29820842187221E-13
     -1.05619326526146E-22  -7.46363131788175E-11  -7.48661340211103E-11  -3.60524808251010E-18
      7.49128080169138E-07
      0.00000000000000E+00  -4.22485791154623E-14   0.00000000000000E+00  -1.78959638669309E-16  -1.70903087194325E-23
      4.22231082511743E-11   4.22229292915185E-11  -1.30429447515566E-18  -1.26062589882715E-02  -1.26062589882909E-02
      0.00000000000000E+00   0.00000000000000E+00   1.93910181832270E-11   0.00000000000000E+00   1.93910181832270E-11
      4.98566817077698E-18  -1.66473461022932E-01  -1.66454049635555E-01   0.00000000000000E+00  -1.73753264038798E-13
     -1.08316473888345E-22  -6.14401942105983E-11  -6.16139474747454E-11  -3.68137369562132E-18
      7.54128080169138E-07
      0.00000000000000E+00  -4.57386791293483E-14   0.00000000000000E+00  -1.02742508076814E-17   2.64086871130902E-24
      4.57437314584826E-11   4.57437211842345E-11  -1.31200279333986E-18  -9.00217785177245E-03  -9.00217785178490E-03
      0.00000000000000E+00   0.00000000000000E+00   1.24473160047083E-11   0.00000000000000E+00   1.24473160047083E-11
      5.04790475080052E-18  -1.86677686014735E-01  -1.86659353150034E-01   0.00000000000000E+00  -1.48110387200565E-13
     -1.10473905630521E-22  -5.80429268016319E-11  -5.81910371889430E-11  -3.73590195746066E-18
      7.59128080169138E-07
      0.00000000000000E+00  -4.88614001944042E-14   0.00000000000000E+00   2.38813816527258E-17   2.49953422598718E-23
      4.89037002496836E-11   4.89037241310902E-11  -1.31471403412246E-18  -7.30213160479577E-03  -7.30213160480510E-03
      0.00000000000000E+00   0.00000000000000E+00   9.33869167645150E-12   0.00000000000000E+00   9.33869167645150E-12
      5.09459820918278E-18  -2.05908922731889E-01  -2.05890573801482E-01   0.00000000000000E+00  -1.38175721162859E-13
     -1.12388197317555E-22  -5.81042400862661E-11  -5.82424158075413E-11  -3.77988417506032E-18
      7.64128080169138E-07
      0.00000000000000E+00  -5.17085870478376E-14   0.00000000000000E+00   2.90523844502451E-17   4.45609841890125E-23
      5.17143625376605E-11   5.17143915900895E-11  -1.31554685060162E-18  -6.29922914914037E-03  -6.29922914914820E-03
      0.00000000000000E+00   0.00000000000000E+00   7.82955405743068E-12   0.00000000000000E+00   7.82955405743068E-12
      5.13374597946993E-18  -2.24209992138671E-01  -2.24191233283653E-01   0.00000000000000E+00  -1.32755167763269E-13
     -1.14150358118513E-22  -5.94111904796429E-11  -5.95439456475204E-11  -3.81819912886831E-18
      7.69128080169138E-07
      0.00000000000000E+00  -5.43720844268558E-14   0.00000000000000E+00   3.11237054472728E-17   5.92415479067698E-23
      5.44131880848156E-11   5.44132192085803E-11  -1.31558296004155E-18  -5.61706759616830E-03  -5.61706759617527E-03
      0.00000000000000E+00   0.00000000000000E+00   6.96981063998569E-12   0.00000000000000E+00   6.96981063998569E-12
      5.16859503266986E-18  -2.41623972696119E-01  -2.41604634566083E-01   0.00000000000000E+00  -1.28111117084407E-13
     -1.15793300733067E-22  -6.12549187313657E-11  -6.13830298485659E-11  -3.85301207262831E-18
      7.74128080169138E-07
      0.00000000000000E+00  -5.71274265430816E-14   0.00000000000000E+00   3.37376852268098E-17   6.93426402264065E-23
      5.71259644990242E-11   5.71259982367788E-11  -1.31520542881132E-18  -5.12714503068407E-03  -5.12714503069046E-03
      0.00000000000000E+00   0.00000000000000E+00   6.38995471023567E-12   0.00000000000000E+00   6.38995471023567E-12
      5.20054480622104E-18  -2.58189441220970E-01  -2.58169431249251E-01   0.00000000000000E+00  -1.23502242020136E-13
     -1.17337161396661E-22  -6.33924507048771E-11  -6.35159529470146E-11  -3.88533937740972E-18
      7.79128080169138E-07
      0.00000000000000E+00  -5.98827686593074E-14   0.00000000000000E+00   3.66500929248667E-17   7.61561346454363E-23
      5.98969676330916E-11   5.98970042832606E-11  -1.31456386212038E-18  -4.77593613438163E-03  -4.77593613438757E-03
      0.00000000000000E+00   0.00000000000000E+00   5.93975310336466E-12   0.00000000000000E+00   5.93975310336466E-12
      5.23024357173786E-18  -2.73940200326823E-01  -2.73919459328337E-01   0.00000000000000E+00  -1.18920488705503E-13
     -1.18796493675520E-22  -6.57178368978011E-11  -6.58367573866254E-11  -3.91567970961748E-18
      7.84128080169138E-07
      0.00000000000000E+00  -6.27299555127408E-14   0.00000000000000E+00   3.94852506868404E-17   8.09252917764858E-23
      6.27433309886689E-11   6.27433704740005E-11  -1.31372036553528E-18  -4.53834899871073E-03  -4.53834899871629E-03
      0.00000000000000E+00   0.00000000000000E+00   5.55517309975395E-12   0.00000000000000E+00   5.55517309975395E-12
      5.25801943723664E-18  -2.88916806555416E-01  -2.88895290119840E-01   0.00000000000000E+00  -1.14520106436730E-13
     -1.20181904860664E-22  -6.81840234671973E-11  -6.82985435737542E-11  -3.94429907170135E-18
      7.89128080169138E-07
      0.00000000000000E+00  -6.56689871033816E-14   0.00000000000000E+00   4.29250508006013E-17   8.45220632821197E-23
      6.56856810590993E-11   6.56857239842346E-11  -1.31269287087057E-18  -4.40567382895417E-03  -4.40567382895938E-03
      0.00000000000000E+00   0.00000000000000E+00   5.20488455163994E-12   0.00000000000000E+00   5.20488455163994E-12
      5.28404385999483E-18  -3.03166921260278E-01  -3.03144588349022E-01   0.00000000000000E+00  -1.10396695351591E-13
     -1.21501419058698E-22  -7.07802118404012E-11  -7.08906085358743E-11  -3.97135098912426E-18
      7.94128080169138E-07
      0.00000000000000E+00  -6.87917081684375E-14   0.00000000000000E+00   4.71915412001862E-17   8.74923263981316E-23
      6.87743837375259E-11   6.87744309291546E-11  -1.31145915994189E-18  -4.38518093121382E-03  -4.38518093121870E-03
      0.00000000000000E+00   0.00000000000000E+00   4.87567505429662E-12   0.00000000000000E+00   4.87567505429662E-12
      5.30842223526632E-18  -3.16765061746032E-01  -3.16741859615793E-01   0.00000000000000E+00  -1.06737418058608E-13
     -1.22763190148641E-22  -7.35433685652698E-11  -7.36501059834511E-11  -3.99696307532442E-18
      7.99128080169138E-07
      0.00000000000000E+00  -7.20981187079085E-14   0.00000000000000E+00   5.36840847199097E-17   9.01760994107515E-23
      7.21099004958754E-11   7.21099541800503E-11  -1.30994154616668E-18  -4.50903161532450E-03  -4.50903161532903E-03
      0.00000000000000E+00   0.00000000000000E+00   4.53432777155092E-12   0.00000000000000E+00   4.53432777155092E-12
      5.33109387412407E-18  -3.29759114121923E-01  -3.29734968845759E-01   0.00000000000000E+00  -1.03124027905636E-13
     -1.23969327062705E-22  -7.65411579235719E-11  -7.66442819516015E-11  -4.02115232795739E-18
      8.04128080169138E-07
      0.00000000000000E+00  -7.59555976706246E-14   0.00000000000000E+00   6.53243929263631E-17   9.28415824019668E-23
      7.59161049681444E-11   7.59161702926302E-11  -1.30794661078132E-18  -4.86123943523191E-03  -4.86123943523603E-03
      0.00000000000000E+00   0.00000000000000E+00   4.12065504235508E-12   0.00000000000000E+00   4.12065504235508E-12
      5.35169714933585E-18  -3.42150663827355E-01  -3.42125449912817E-01   0.00000000000000E+00  -9.86644190636243E-14
     -1.25111253587142E-22  -7.99381609157965E-11  -8.00368253349852E-11  -4.04375053855452E-18
      8.09128080169138E-07
      0.00000000000000E+00  -8.07315240054160E-14   0.00000000000000E+00   9.00208767072521E-17   9.58727416799417E-23
      8.07743295102020E-11   8.07744195311746E-11  -1.30498709706437E-18  -5.65298848476233E-03  -5.65298848476586E-03
      0.00000000000000E+00   0.00000000000000E+00   3.52969193363801E-12   0.00000000000000E+00   3.52969193363801E-12
      5.36934560900404E-18  -3.53945561798154E-01  -3.53919003682793E-01   0.00000000000000E+00  -9.21856624012069E-14
     -1.26167095112464E-22  -8.42119258022851E-11  -8.43041114648125E-11  -4.06435851193967E-18
      8.14128080169138E-07
      0.00000000000000E+00  -8.82627924564332E-14   0.00000000000000E+00   1.52832604074212E-16   1.00123193184264E-22
      8.82995758586072E-11   8.82997286913114E-11  -1.29979777109434E-18  -7.43060384838180E-03  -7.43060384838428E-03
      0.00000000000000E+00   0.00000000000000E+00   2.48355563519111E-12   0.00000000000000E+00   2.48355563519111E-12
      5.38176338717999E-18  -3.65154379103047E-01  -3.65125779992737E-01   0.00000000000000E+00  -8.04706209840848E-14
     -1.27078642316284E-22  -9.07028137053912E-11  -9.07832843265023E-11  -4.08196561608565E-18
      8.19128080169138E-07
      0.00000000000000E+00  -1.03141639884053E-13   0.00000000000000E+00   3.00488203089215E-16   1.07635151995762E-22
      1.03173573937701E-10   1.03173874426011E-10  -1.28917698510097E-18  -1.15633431252657E-02  -1.15633431252660E-02
      0.00000000000000E+00   0.00000000000000E+00   2.79142669586411E-13   0.00000000000000E+00   2.79142669586411E-13
      5.38315910052792E-18  -3.75773149671092E-01  -3.75740559389240E-01   0.00000000000000E+00  -5.53665491802090E-14
     -1.27696388851630E-22  -1.03397650546290E-10  -1.03453017095598E-10  -4.09398211542695E-18
      8.24128080169138E-07
      0.00000000000000E+00  -1.38226329497328E-13   0.00000000000000E+00   6.57900306317696E-16   1.21883357785947E-22
      1.38203100630977E-10   1.38203758531405E-10  -1.26668040490118E-18  -2.07307891171815E-02  -2.07307891171772E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.29515925809633E-12   0.00000000000000E+00  -4.29515925809633E-12
      5.36168330423744E-18  -3.85744818075852E-01  -3.85702633631885E-01   0.00000000000000E+00  -4.51673540496806E-15
     -1.27731675099012E-22  -1.33904082537776E-10  -1.33908599273309E-10  -4.09500289933626E-18
      8.29128080169138E-07
      0.00000000000000E+00  -2.21253971932932E-13   0.00000000000000E+00   1.34168267652115E-15   1.43204507172118E-22
      2.21265130480209E-10   2.21266472163029E-10  -1.22629546989724E-18  -3.72118580269096E-02  -3.72118580268983E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.13038992556056E-11   0.00000000000000E+00  -1.13038992556056E-11
      5.30516380795942E-18  -3.94884084359553E-01  -3.94817941009502E-01   0.00000000000000E+00   6.50406657408823E-14
     -1.26972514069277E-22  -2.10027613573037E-10  -2.09962572907423E-10  -4.07886833806217E-18
      8.34128080169138E-07
      0.00000000000000E+00  -3.95116059466780E-13   0.00000000000000E+00   2.33847145793194E-15   1.63829459451797E-22
      3.95152219052458E-10   3.95154557524079E-10  -1.17191129627515E-18  -5.92133006532606E-02  -5.92133006532429E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.77159120987121E-11   0.00000000000000E+00  -1.77159120987121E-11
      5.21658424746586E-18  -4.02798106772525E-01  -4.02679203797729E-01   0.00000000000000E+00   1.11751375029018E-13
     -1.25669779285608E-22  -3.77550396800271E-10  -3.77438645425367E-10  -4.04467295119070E-18
      8.39128080169138E-07
      0.00000000000000E+00  -7.15746037058256E-13   0.00000000000000E+00   3.76855034936456E-15   1.79047010902693E-22
      7.15697157018449E-10   7.15700925568977E-10  -1.11346384023848E-18  -8.31665760724246E-02  -8.31665760724028E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.18173618606307E-11   0.00000000000000E+00  -2.18173618606307E-11
      5.10749743816270E-18  -4.08840896942810E-01  -4.08622304299218E-01   0.00000000000000E+00   1.26256372803639E-13
     -1.24176859739981E-22  -6.94009820081026E-10  -6.93883563708346E-10  -3.99403359792422E-18
      8.44128080169138E-07
      0.00000000000000E+00  -1.24605754969452E-12   0.00000000000000E+00   5.83002148527797E-15   1.90339426336756E-22
      1.24601035633199E-09   1.24601618635366E-09  -1.05791946573165E-18  -1.06979426157599E-01  -1.06979426157574E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.46226508277156E-11   0.00000000000000E+00  -2.46226508277156E-11
      4.98438418402412E-18  -4.12103720436446E-01  -4.11718945146148E-01   0.00000000000000E+00   1.29926012470304E-13
     -1.22603824847552E-22  -1.22152346153829E-09  -1.22139353552594E-09  -3.92646471829248E-18
      8.49128080169138E-07
      0.00000000000000E+00  -2.04225957654656E-12   0.00000000000000E+00   8.33008475597710E-15   1.99232885441268E-22
      2.04228370014428E-09   2.04229203022923E-09  -1.00780437357653E-18  -1.29936026604318E-01  -1.29936026604290E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.72860084956110E-11   0.00000000000000E+00  -2.72860084956110E-11
      4.84795414154607E-18  -4.11460551384422E-01  -4.10825760536518E-01   0.00000000000000E+00   1.37413072910845E-13
     -1.20895037517770E-22  -2.01514343480641E-09  -2.01500602173362E-09  -3.84014976796953E-18
      8.54128080169137E-07
      0.00000000000000E+00  -3.13750806774632E-12   0.00000000000000E+00   1.12175841581347E-14   2.05760202090110E-22
      3.13752138454444E-09   3.13753260212881E-09  -9.63166651774605E-19  -1.51877614380069E-01  -1.51877614380039E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.01438991603262E-11   0.00000000000000E+00  -3.01438991603262E-11
      4.69723464574444E-18  -4.05683362882834E-01  -4.04704430033285E-01   0.00000000000000E+00   1.53529521178304E-13
     -1.18930581585297E-22  -3.10754223248954E-09  -3.10738870296848E-09  -3.73406799396983E-18
      8.59128080169137E-07
      0.00000000000000E+00  -4.53272147066586E-12   0.00000000000000E+00   1.41240153187904E-14   2.09262230256003E-22
      4.53270906344141E-09   4.53272318745694E-09  -9.23218120415907E-19  -1.72786688733616E-01  -1.72786688733583E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.29928333840364E-11   0.00000000000000E+00  -3.29928333840364E-11
      4.53227047882426E-18  -3.93594817670958E-01  -3.92177238578803E-01   0.00000000000000E+00   1.79425407820948E-13
     -1.16566176766858E-22  -4.49990977948061E-09  -4.49973035407291E-09  -3.60905235840835E-18
      8.64128080169137E-07
      0.00000000000000E+00  -6.20245879309870E-12   0.00000000000000E+00   1.67893179023826E-14   2.09218805053294E-22
      6.20241543194186E-09   6.20243222125998E-09  -8.87031945094747E-19  -1.92690811740219E-01  -1.92690811740183E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.55373542094137E-11   0.00000000000000E+00  -3.55373542094137E-11
      4.35458370777719E-18  -3.74190062209980E-01  -3.72247246944877E-01   0.00000000000000E+00   2.14116451459151E-13
     -1.13648343849649E-22  -6.16710898350190E-09  -6.16689486705055E-09  -3.46755176268244E-18
      8.69128080169137E-07
      0.00000000000000E+00  -8.10419592171775E-12   0.00000000000000E+00   1.90015816927392E-14   2.05756335110924E-22
      8.10415311585576E-09   8.10417211743766E-09  -8.53798881306759E-19  -2.11632316295641E-01  -2.11632316295603E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.75756656941738E-11   0.00000000000000E+00  -3.75756656941738E-11
      4.16670537930632E-18  -3.46712338725925E-01  -3.44171013454161E-01   0.00000000000000E+00   2.53935035710633E-13
     -1.10026744839273E-22  -8.06685038677908E-09  -8.06659645174348E-09  -3.31290649799956E-18
      8.74128080169137E-07
      0.00000000000000E+00  -1.01785093115497E-11   0.00000000000000E+00   2.07205909533582E-14   1.99838193813584E-22
      1.01784939462529E-08   1.01785146668440E-08  -8.22895974642908E-19  -2.29656402398813E-01  -2.29656402398774E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.90892867890553E-11   0.00000000000000E+00  -3.90892867890553E-11
      3.97125894536104E-18  -3.10730740367474E-01  -3.07536342235419E-01   0.00000000000000E+00   2.90278432949243E-13
     -1.05553886347756E-22  -1.01397156584878E-08  -1.01394253800550E-08  -3.14836297071813E-18
      8.79128080169137E-07
      0.00000000000000E+00  -1.23195019805944E-11   0.00000000000000E+00   2.13564639685751E-14   1.92266356781002E-22
      1.23194628141730E-08   1.23194841706372E-08  -7.93928080707441E-19  -2.46806065207220E-01  -2.46806065207179E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.04086727605130E-11   0.00000000000000E+00  -4.04086727605130E-11
      3.76921558155848E-18  -2.66351508327569E-01  -2.62482962954672E-01   0.00000000000000E+00   3.06975267418268E-13
     -1.00060408182809E-22  -1.22793824731440E-08  -1.22790754978767E-08  -2.97528750085104E-18
      8.84128080169137E-07
      0.00000000000000E+00  -1.42945312095050E-11   0.00000000000000E+00   1.96997894191731E-14   1.79903646419927E-22
      1.42945091729184E-08   1.42945288727080E-08  -7.66811869248822E-19  -2.63118397486879E-01  -2.63118397486837E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.24737779315454E-11   0.00000000000000E+00  -4.24737779315454E-11
      3.55684669190075E-18  -2.14766293051214E-01  -2.10276093926225E-01   0.00000000000000E+00   2.84151301342362E-13
     -9.35914705958814E-23  -1.42523392460776E-08  -1.42520550947764E-08  -2.79003482265192E-18
      8.89128080169137E-07
      0.00000000000000E+00  -1.57786503180415E-11   0.00000000000000E+00   1.48328974944355E-14   1.54360314858521E-22
      1.57785996839430E-08   1.57786145168407E-08  -7.41623257197841E-19  -2.78626854839765E-01  -2.78626854839719E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.57464728912639E-11   0.00000000000000E+00  -4.57464728912639E-11
      3.32811432744443E-18  -1.58613635765960E-01  -1.53656841774854E-01   0.00000000000000E+00   2.25771575955998E-13
     -8.72859823258049E-23  -1.57330938155253E-08  -1.57328680439494E-08  -2.58649107024659E-18
      8.94128080169137E-07
      0.00000000000000E+00  -1.65317771631432E-11   0.00000000000000E+00   2.49655554891710E-13   1.14729922260974E-22
      1.65317710399183E-08   1.65320206954733E-08  -7.18115474824754E-19  -2.93374030471400E-01  -2.93374030471353E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.80025165832603E-11   0.00000000000000E+00  -4.80025165832603E-11
      3.08810174452813E-18  -1.01532521444724E-01  -9.63391029957907E-02   0.00000000000000E+00  -7.29334258355333E-14
     -8.09815944345504E-23  -1.64839452454642E-08  -1.64840181788901E-08  -2.36998626970337E-18
      8.99128080169137E-07
      0.00000000000000E+00  -1.53420204373569E-11   0.00000000000000E+00  -1.15932975978975E-14   6.37357432141463E-23
      1.53420772559261E-08   1.53420656626285E-08  -6.95698632773042E-19  -3.07412630442496E-01  -3.07412630442449E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.66908045031923E-11   0.00000000000000E+00  -4.66908045031923E-11
      2.85464772201216E-18  -5.27486074298504E-02  -4.79295800663820E-02   0.00000000000000E+00   1.32472348453889E-13
     -5.81862975985040E-23  -1.52955073304737E-08  -1.52953748581253E-08  -2.15894908923913E-18
      9.04128080169137E-07
      0.00000000000000E+00  -1.13791955610637E-11   0.00000000000000E+00  -3.89517991060644E-14   2.80698600502809E-23
      1.13792017934674E-08   1.13791628416683E-08  -6.71267007287267E-19  -3.20821336857005E-01  -3.20821336856969E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.57834365687640E-11   0.00000000000000E+00  -3.57834365687640E-11
      2.67573053916835E-18  -2.49879163306759E-02  -2.14140099633831E-02   0.00000000000000E+00   1.02420494138076E-13
     -2.80815362535033E-23  -1.13434818255936E-08  -1.13433794050995E-08  -2.00446353188108E-18
      9.09128080169137E-07
      0.00000000000000E+00  -8.18658065099290E-12   0.00000000000000E+00  -3.13346789735397E-14   1.38438258049272E-23
      8.18658034068015E-09   8.18654900600119E-09  -6.44314260918852E-19  -3.33630517848991E-01  -3.33630517848966E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.45742725420067E-11   0.00000000000000E+00  -2.45742725420067E-11
      2.55285917645831E-18  -1.36120502564107E-02  -1.10404898948840E-02   0.00000000000000E+00   6.37862273331909E-14
     -1.42944528332622E-23  -8.16203851968650E-09  -8.16197473345918E-09  -1.90854491553946E-18
      9.14128080169137E-07
      0.00000000000000E+00  -6.80229677180105E-12   0.00000000000000E+00  -1.35000733086067E-14   8.53604989634331E-24
      6.80227837391580E-09   6.80226487384249E-09  -6.16673424502173E-19  -3.45839586576088E-01  -3.45839586576069E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.90736120204743E-11   0.00000000000000E+00  -1.90736120204743E-11
      2.45749111635594E-18  -9.30109614114923E-03  -7.16394106559066E-03   0.00000000000000E+00   3.42309936144198E-14
     -9.44721605338024E-24  -6.78322549281563E-09  -6.78319126182202E-09  -1.84081769185377E-18
      9.19128080169137E-07
      0.00000000000000E+00  -6.33067404624040E-12   0.00000000000000E+00  -4.51165578616613E-15   6.21591143182956E-24
      6.33062465639738E-09   6.33062014474160E-09  -5.89373606383047E-19  -3.57457388761914E-01  -3.57457388761897E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.67756235861903E-11   0.00000000000000E+00  -1.67756235861903E-11
      2.37361299842499E-18  -7.41172974656676E-03  -5.42244823447642E-03   0.00000000000000E+00   2.06749022112759E-14
     -7.26898197862967E-24  -6.31386519605762E-09  -6.31384452115541E-09  -1.78423939204194E-18
      9.24128080169137E-07
      0.00000000000000E+00  -6.17187449560859E-12   0.00000000000000E+00  -1.43847278016304E-15   4.91716382625262E-24
      6.17190094962808E-09   6.17189951115531E-09  -5.62836175954494E-19  -3.68494900851002E-01  -3.68494900850987E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.56351308044101E-11   0.00000000000000E+00  -1.56351308044101E-11
      2.29543734440294E-18  -6.35397034761148E-03  -4.41433558507994E-03   0.00000000000000E+00   1.52116535639365E-14
     -5.96827832028351E-24  -6.15627959200446E-09  -6.15626438035090E-09  -1.73260116844845E-18
      9.29128080169137E-07
      0.00000000000000E+00  -6.10684842166566E-12   0.00000000000000E+00  -5.27165508803068E-16   4.06096351078081E-24
      6.10685308762238E-09   6.10685256045687E-09  -5.37318802178225E-19  -3.78944615452851E-01  -3.78944615452837E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.48624324393391E-11   0.00000000000000E+00  -1.48624324393391E-11
      2.22112518220624E-18  -5.64789724761403E-03  -3.72851187675532E-03   0.00000000000000E+00   1.25847051018636E-14
     -5.05778477985861E-24  -6.09200271272264E-09  -6.09199012801754E-09  -1.68380638002802E-18
      9.34128080169137E-07
      0.00000000000000E+00  -6.07121266362914E-12   0.00000000000000E+00  -2.49587492114768E-16   3.45537973247006E-24
      6.07118296250422E-09   6.07118271291673E-09  -5.13156133127472E-19  -3.88737910296226E-01  -3.88737910296211E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.41241582848199E-11   0.00000000000000E+00  -1.41241582848199E-11
      2.15050439078214E-18  -5.13874225785868E-03  -3.23036154624892E-03   0.00000000000000E+00   1.08171174938064E-14
     -4.38184089203976E-24  -6.05706937174940E-09  -6.05705855463191E-09  -1.63734825765467E-18
      9.39128080169137E-07
      0.00000000000000E+00  -6.04641458458311E-12   0.00000000000000E+00  -1.53265529221942E-16   3.01743717124545E-24
      6.04642207172899E-09   6.04642191846347E-09  -4.90991581805808E-19  -3.97665568727341E-01  -3.97665568727328E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.31139807101047E-11   0.00000000000000E+00  -1.31139807101047E-11
      2.08493448723162E-18  -4.76467339346546E-03  -2.86377475890012E-03   0.00000000000000E+00   9.22514572677219E-15
     -3.87896350491104E-24  -6.03331716289909E-09  -6.03330793775336E-09  -1.59394290542581E-18
      9.44128080169137E-07
      0.00000000000000E+00  -6.02593320818583E-12   0.00000000000000E+00  -1.29228836497581E-16   2.70438200426052E-24
      6.02592300013112E-09   6.02592287090228E-09  -4.71972260442768E-19  -4.05302835098187E-01  -4.05302835098175E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14366474007734E-11   0.00000000000000E+00  -1.14366474007734E-11
      2.02775125022775E-18  -4.49617046329064E-03  -2.60120115305920E-03   0.00000000000000E+00   7.49079889736658E-15
     -3.52191729116028E-24  -6.01449371430040E-09  -6.01448622350151E-09  -1.55577898978498E-18
      9.49128080169137E-07
      0.00000000000000E+00  -6.00618658968621E-12   0.00000000000000E+00  -1.42689675687482E-16   2.49404116447739E-24
      6.00614559487876E-09   6.00614545218908E-09  -4.57848024553777E-19  -4.10969066314210E-01  -4.10969066314202E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.63102717592904E-12   0.00000000000000E+00  -8.63102717592904E-12
      1.98459611434811E-18  -4.31960225102985E-03  -2.42997964928750E-03   0.00000000000000E+00   5.37103030542443E-15
     -3.30203314156149E-24  -5.99751979604346E-09  -5.99751442501316E-09  -1.52674808979433E-18
      9.54128080169136E-07
      0.00000000000000E+00  -5.98423569749361E-12   0.00000000000000E+00  -1.91197134679485E-16   2.37796473135882E-24
      5.98422917616321E-09   5.98422898496608E-09  -4.50980929929477E-19  -4.13723965090819E-01  -4.13723965090815E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.24785210911548E-12   0.00000000000000E+00  -4.24785210911548E-12
      1.96335685380253E-18  -4.23337954964604E-03  -2.34928085732249E-03   0.00000000000000E+00   2.64265407706667E-15
     -3.22923285682045E-24  -5.97998377551104E-09  -5.97998113285696E-09  -1.51237592387305E-18
      9.59128080169136E-07
      0.00000000000000E+00  -5.95677412106856E-12   0.00000000000000E+00  -2.82096156122767E-16   2.36061215348083E-24
      5.95680286927709E-09   5.95680258718094E-09  -4.54229616723913E-19  -4.12420358278582E-01  -4.12420358278584E-01
      0.00000000000000E+00   0.00000000000000E+00   1.99947777417829E-12   0.00000000000000E+00   1.99947777417829E-12
      1.97335424267342E-18  -4.25063080712477E-03  -2.37320507042846E-03   0.00000000000000E+00  -9.41966541743091E-16
     -3.34329817404046E-24  -5.95880112298856E-09  -5.95880206495511E-09  -1.51912462594951E-18
      9.64128080169136E-07
      0.00000000000000E+00  -5.91829117617861E-12   0.00000000000000E+00  -4.40111758073531E-16   2.46376651640672E-24
      5.91829460184304E-09   5.91829416173128E-09  -4.70663878682042E-19  -4.05828048427100E-01  -4.05828048427111E-01
      0.00000000000000E+00   0.00000000000000E+00   1.00405188718886E-11   0.00000000000000E+00   1.00405188718886E-11
      2.02355683703286E-18  -4.41053316500279E-03  -2.54270733658245E-03   0.00000000000000E+00  -4.62770968002865E-15
     -3.74679912607092E-24  -5.92833005289348E-09  -5.92833468060317E-09  -1.55289295835082E-18
      9.69128080169136E-07
      0.00000000000000E+00  -5.85657151277515E-12   0.00000000000000E+00  -7.34499428704251E-16   2.73839944822179E-24
      5.85656057383926E-09   5.85655983933983E-09  -5.03131450221153E-19  -3.92785935636497E-01  -3.92785935636516E-01
      0.00000000000000E+00   0.00000000000000E+00   1.93718570479411E-11   0.00000000000000E+00   1.93718570479411E-11
      2.12041612227257E-18  -4.81034611648341E-03  -2.95903207343873E-03   0.00000000000000E+00  -1.20747550225940E-14
     -4.69969678268611E-24  -5.87591962163274E-09  -5.87593169638777E-09  -1.61728467205141E-18
      9.74128080169136E-07
      0.00000000000000E+00  -5.74011238599601E-12   0.00000000000000E+00   7.29866937963288E-16   3.28690799076874E-24
      5.74011707698608E-09   5.74011780685302E-09  -5.53617576932654E-19  -3.72317481087932E-01  -3.72317481087962E-01
      0.00000000000000E+00   0.00000000000000E+00   2.92954386220930E-11   0.00000000000000E+00   2.92954386220930E-11
      2.26689331538304E-18  -5.69537485360019E-03  -3.87762418359673E-03   0.00000000000000E+00  -2.29491881588299E-14
     -6.90050932472826E-24  -5.76939029628695E-09  -5.76941324547511E-09  -1.71327573845038E-18
      9.79128080169136E-07
      0.00000000000000E+00  -5.48267158760331E-12   0.00000000000000E+00  -3.02413811269608E-15   4.28008552935272E-24
      5.48269748549711E-09   5.48269446135901E-09  -6.22114851412395E-19  -3.43702211559249E-01  -3.43702211559289E-01
      0.00000000000000E+00   0.00000000000000E+00   3.96935135548919E-11   0.00000000000000E+00   3.96935135548919E-11
      2.46536088315749E-18  -7.70902244473831E-03  -5.96910400305709E-03   0.00000000000000E+00  -3.30349219943577E-14
     -1.22695385819111E-23  -5.52235493999189E-09  -5.52238797491390E-09  -1.84324603174510E-18
      9.84128080169136E-07
      0.00000000000000E+00  -4.87410835886624E-12   0.00000000000000E+00  -6.49126617673472E-15   5.81940022083243E-24
      4.87406717540833E-09   4.87406068414216E-09  -7.05289199279867E-19  -3.06559462037948E-01  -3.06559462038000E-01
      0.00000000000000E+00   0.00000000000000E+00   5.22711275176777E-11   0.00000000000000E+00   5.22711275176777E-11
      2.72671652074588E-18  -1.24531383775114E-02  -1.09010219222004E-02   0.00000000000000E+00  -5.05029768150205E-14
     -2.52067531249164E-23  -4.92628130868300E-09  -4.92633181165984E-09  -2.02142732146602E-18
      9.89128080169136E-07
      0.00000000000000E+00  -3.61969293808584E-12   0.00000000000000E+00  -1.30351170928245E-14   6.87612266566758E-24
      3.61965886259598E-09   3.61964582747890E-09  -7.97825656872793E-19  -2.61088732628237E-01  -2.61088732628306E-01
      0.00000000000000E+00   0.00000000000000E+00   6.89788620837120E-11   0.00000000000000E+00   6.89788620837120E-11
      3.07161083116444E-18  -2.28407561401561E-02  -2.16786035661952E-02   0.00000000000000E+00  -7.55535834218401E-14
     -4.95681634734364E-23  -3.68854913597914E-09  -3.68862468956261E-09  -2.27378517429165E-18
      9.94128080169136E-07
      0.00000000000000E+00  -1.93654628402070E-12   0.00000000000000E+00  -1.74031068441648E-14   2.53972796561329E-24
      1.93658027559824E-09   1.93656287249140E-09  -8.97824674689854E-19  -2.08658585123508E-01  -2.08658585123593E-01
      0.00000000000000E+00   0.00000000000000E+00   8.41892607228634E-11   0.00000000000000E+00   8.41892607228634E-11
      3.49255713477876E-18  -4.06414981521325E-02  -4.00048361311702E-02   0.00000000000000E+00  -1.15619560279794E-13
     -7.51225571027875E-23  -2.02063651365391E-09  -2.02075213321427E-09  -2.59473246008890E-18
      9.99128080169136E-07
      0.00000000000000E+00  -7.27042939734782E-13   0.00000000000000E+00   8.75903722191121E-14  -1.09132077780708E-23
      7.27046282852907E-10   7.27133873225115E-10  -1.00720212088961E-18  -1.52043057690540E-01  -1.52043057690628E-01
      0.00000000000000E+00   0.00000000000000E+00   8.85655942432228E-11   0.00000000000000E+00   8.85655942432228E-11
      3.93538510599487E-18  -6.33047413436025E-02  -6.30477793100724E-02   0.00000000000000E+00  -2.76019648511012E-13
     -8.87812453116748E-23  -8.15423447819738E-10  -8.15699467468338E-10  -2.92818298510526E-18
      1.00412808016914E-06
      0.00000000000000E+00  -2.08120174512256E-13   0.00000000000000E+00  -6.37176581710633E-15  -2.65133415320994E-23
      2.08094250371066E-10   2.08087878605222E-10  -1.12410091281914E-18  -9.51328809739793E-02  -9.51328809740610E-02
      0.00000000000000E+00   0.00000000000000E+00   8.17071394828757E-11   0.00000000000000E+00   8.17071394828757E-11
      4.34392080340925E-18  -8.73748073586570E-02  -8.72835055307997E-02   0.00000000000000E+00  -2.49402653460005E-13
     -9.45005384058423E-23  -2.89545615434543E-10  -2.89795018088098E-10  -3.21981989059012E-18
      1.00912808016914E-06
      0.00000000000000E+00  -6.04338370825526E-14   0.00000000000000E+00  -2.68303465909516E-15  -3.46119387080234E-23
      6.04649559290399E-11   6.04622728943462E-11  -1.22505204994836E-18  -4.83199410115597E-02  -4.83199410116231E-02
      0.00000000000000E+00   0.00000000000000E+00   6.34050755502742E-11   0.00000000000000E+00   6.34050755502742E-11
      4.66094618116062E-18  -1.11075970491138E-01  -1.11036945509055E-01   0.00000000000000E+00  -2.90790695998709E-13
     -1.00264141038670E-22  -1.23576557748522E-10  -1.23867348444621E-10  -3.43589413121227E-18
      1.01412808016914E-06
      0.00000000000000E+00  -3.74726527806709E-14   0.00000000000000E+00  -8.94163495557911E-16  -3.32773142574518E-23
      3.75169709383815E-11   3.75160767748527E-11  -1.28159785618688E-18  -2.29985882415389E-02  -2.29985882415773E-02
      0.00000000000000E+00   0.00000000000000E+00   3.84712640328229E-11   0.00000000000000E+00   3.84712640328229E-11
      4.85330250132474E-18  -1.33863690995481E-01  -1.33839751000479E-01   0.00000000000000E+00  -2.37606473485658E-13
     -1.04468017102955E-22  -7.57497343340853E-11  -7.59873408076755E-11  -3.57170464513786E-18
      1.01912808016914E-06
      0.00000000000000E+00  -3.93095475248215E-14   0.00000000000000E+00  -1.03788063872928E-16  -2.36707868291722E-23
      3.93382883277104E-11   3.93381845396229E-11  -1.30482883887223E-18  -1.28594581642506E-02  -1.28594581642720E-02
      0.00000000000000E+00   0.00000000000000E+00   2.14837627733567E-11   0.00000000000000E+00   2.14837627733567E-11
      4.96072131519152E-18  -1.55624800397210E-01  -1.55605638493368E-01   0.00000000000000E+00  -1.76275503724207E-13
     -1.07289119956587E-22  -6.06456718091482E-11  -6.08219473129797E-11  -3.65589247631930E-18
      1.02412808016914E-06
      0.00000000000000E+00  -4.34425606991602E-14   0.00000000000000E+00  -4.09836436236184E-18  -5.75336199665433E-24
      4.34793580200781E-11   4.34793539217080E-11  -1.31310357008176E-18  -8.99458922710826E-03  -8.99458922712164E-03
      0.00000000000000E+00   0.00000000000000E+00   1.33729843197506E-11   0.00000000000000E+00   1.33729843197506E-11
      5.02758623679027E-18  -1.76355165088687E-01  -1.76337253919461E-01   0.00000000000000E+00  -1.48630149787160E-13
     -1.09512580030639E-22  -5.67037080915620E-11  -5.68523382414586E-11  -3.71448266670851E-18
      1.02912808016914E-06
      0.00000000000000E+00  -4.69326607130462E-14   0.00000000000000E+00   3.03613891580349E-17   1.69655679674259E-23
      4.69577806133191E-11   4.69578109747253E-11  -1.31584655885234E-18  -7.25424985355664E-03  -7.25424985356645E-03
      0.00000000000000E+00   0.00000000000000E+00   9.80287096896156E-12   0.00000000000000E+00   9.80287096896156E-12
      5.07660059163508E-18  -1.96087068395512E-01  -1.96069186221863E-01   0.00000000000000E+00  -1.38911784430387E-13
     -1.11482997642780E-22  -5.66217701591450E-11  -5.67606819436869E-11  -3.76075403278274E-18
      1.03412808016914E-06
      0.00000000000000E+00  -4.98716923036870E-14   0.00000000000000E+00   3.29208495750250E-17   3.81087654856207E-23
      4.99096819375050E-11   4.99097148583927E-11  -1.31660139776670E-18  -6.25390846975056E-03  -6.25390846975866E-03
      0.00000000000000E+00   0.00000000000000E+00   8.10738240408616E-12   0.00000000000000E+00   8.10738240408616E-12
      5.11713750365551E-18  -2.14864147287510E-01  -2.14845869399164E-01   0.00000000000000E+00  -1.34066491453212E-13
     -1.13298286803585E-22  -5.78830307709123E-11  -5.80170972624788E-11  -3.80053610588882E-18
      1.03912808016914E-06
      0.00000000000000E+00  -5.26270344199128E-14   0.00000000000000E+00   3.31583791884235E-17   5.46111732329885E-23
      5.26661932065754E-11   5.26662263650092E-11  -1.31655985610139E-18  -5.57700747894851E-03  -5.57700747895568E-03
      0.00000000000000E+00   0.00000000000000E+00   7.16792312809663E-12   0.00000000000000E+00   7.16792312809663E-12
      5.15297711929600E-18  -2.32731596607280E-01  -2.32712746381179E-01   0.00000000000000E+00  -1.29835398356174E-13
     -1.14988853690321E-22  -5.97043140946346E-11  -5.98341494931057E-11  -3.83641726319460E-18
      1.04412808016914E-06
      0.00000000000000E+00  -5.53823765361386E-14   0.00000000000000E+00   3.47343423261214E-17   6.61579070276736E-23
      5.54001376782512E-11   5.54001724126597E-11  -1.31612841077783E-18  -5.08653164090991E-03  -5.08653164091647E-03
      0.00000000000000E+00   0.00000000000000E+00   6.55470170925106E-12   0.00000000000000E+00   6.55470170925106E-12
      5.18575062784225E-18  -2.49731692225225E-01  -2.49712173996700E-01   0.00000000000000E+00  -1.25458422287236E-13
     -1.16574380849996E-22  -6.18294156995072E-11  -6.19548741219110E-11  -3.86962221706442E-18
      1.04912808016914E-06
      0.00000000000000E+00  -5.81377186523644E-14   0.00000000000000E+00   3.69604611923519E-17   7.39070063913765E-23
      5.81731727631485E-11   5.81732097236836E-11  -1.31546098612832E-18  -4.72624617311780E-03  -4.72624617312389E-03
      0.00000000000000E+00   0.00000000000000E+00   6.09323377044299E-12   0.00000000000000E+00   6.09323377044299E-12
      5.21621679669447E-18  -2.65900322552603E-01  -2.65880076203354E-01   0.00000000000000E+00  -1.20986308547793E-13
     -1.18070934791461E-22  -6.41454571854604E-11  -6.42664434941262E-11  -3.90075581056615E-18
      1.05412808016914E-06
      0.00000000000000E+00  -6.09849055057978E-14   0.00000000000000E+00   3.93088728185666E-17   7.92115177351259E-23
      6.10020783335797E-11   6.10021176425317E-11  -1.31462241323876E-18  -4.46900259556877E-03  -4.46900259557447E-03
      0.00000000000000E+00   0.00000000000000E+00   5.70623658132265E-12   0.00000000000000E+00   5.70623658132265E-12
      5.24474797960108E-18  -2.81271715980300E-01  -2.81250700452715E-01   0.00000000000000E+00  -1.16571290771362E-13
     -1.19490234401633E-22  -6.65917829329636E-11  -6.67083542238545E-11  -3.93012556636232E-18
      1.05912808016914E-06
      0.00000000000000E+00  -6.39239370964386E-14   0.00000000000000E+00   4.17682677696704E-17   8.30863075538095E-23
      6.38978436920142E-11   6.38978854603651E-11  -1.31363710798380E-18  -4.30263188326310E-03  -4.30263188326846E-03
      0.00000000000000E+00   0.00000000000000E+00   5.35931328393643E-12   0.00000000000000E+00   5.35931328393643E-12
      5.27154454602076E-18  -2.95889837861103E-01  -2.95868019471249E-01   0.00000000000000E+00  -1.12385882024835E-13
     -1.20841164471845E-22  -6.91448128621557E-11  -6.92571987443014E-11  -3.95790743803696E-18
      1.06412808016914E-06
      0.00000000000000E+00  -6.68629686870795E-14   0.00000000000000E+00   4.44776710966932E-17   8.61723565347407E-23
      6.68860834312712E-11   6.68861279090285E-11  -1.31250046756711E-18  -4.22694057180872E-03  -4.22694057181375E-03
      0.00000000000000E+00   0.00000000000000E+00   5.03548781059190E-12   0.00000000000000E+00   5.03548781059190E-12
      5.29672198507372E-18  -3.09811997885985E-01  -3.09789340228189E-01   0.00000000000000E+00  -1.08555249283108E-13
     -1.22131362266286E-22  -7.18130604702152E-11  -7.19216157196204E-11  -3.98422151750661E-18
      1.06912808016914E-06
      0.00000000000000E+00  -6.99856897521354E-14   0.00000000000000E+00   4.89405026870161E-17   8.88577592325220E-23
      7.00279874098375E-11   7.00280363504290E-11  -1.31117123241371E-18  -4.25711335057315E-03  -4.25711335057787E-03
      0.00000000000000E+00   0.00000000000000E+00   4.72369300956346E-12   0.00000000000000E+00   4.72369300956346E-12
      5.32034045012154E-18  -3.23114931387669E-01  -3.23091382265947E-01   0.00000000000000E+00  -1.05177226561111E-13
     -1.23368070007307E-22  -7.46465521333082E-11  -7.47517293599926E-11  -4.00916921770783E-18
      1.07412808016914E-06
      0.00000000000000E+00  -7.34757897660214E-14   0.00000000000000E+00   5.58826723191421E-17   9.13911061049408E-23
      7.34407866850138E-11   7.34408425677775E-11  -1.30954814307186E-18  -4.43641637592168E-03  -4.43641637592606E-03
      0.00000000000000E+00   0.00000000000000E+00   4.37983243100453E-12   0.00000000000000E+00   4.37983243100453E-12
      5.34223961227656E-18  -3.35818599723566E-01  -3.35794083903007E-01   0.00000000000000E+00  -1.01501856748864E-13
     -1.24549071955127E-22  -7.77191731419088E-11  -7.78206749987822E-11  -4.03269146920470E-18
      1.07912808016914E-06
      0.00000000000000E+00  -7.74251134659451E-14   0.00000000000000E+00   6.93455997958045E-17   9.40184097974161E-23
      7.74077911635616E-11   7.74078605092554E-11  -1.30738478784712E-18  -4.87191222637792E-03  -4.87191222638186E-03
      0.00000000000000E+00   0.00000000000000E+00   3.94335295525346E-12   0.00000000000000E+00   3.94335295525346E-12
      5.36195637705283E-18  -3.47923067156427E-01  -3.47897439227225E-01   0.00000000000000E+00  -9.67504688749294E-14
     -1.25663146638322E-22  -8.12544629955082E-11  -8.13512134645088E-11  -4.05457158920571E-18
      1.08412808016914E-06
      0.00000000000000E+00  -8.26602634867741E-14   0.00000000000000E+00   1.01343944854425E-16   9.71872546522784E-23
      8.26858019262768E-11   8.26859032703188E-11  -1.30405454047566E-18  -5.83495099041650E-03  -5.83495099041978E-03
      0.00000000000000E+00   0.00000000000000E+00   3.28119759439763E-12   0.00000000000000E+00   3.28119759439763E-12
      5.37836236502482E-18  -3.59438664955422E-01  -3.59411583009831E-01   0.00000000000000E+00  -8.94246318003994E-14
     -1.26682122825135E-22  -8.58776762327892E-11  -8.59671008647162E-11  -4.07430782454916E-18
      1.08912808016914E-06
      0.00000000000000E+00  -9.13855135214891E-14   0.00000000000000E+00   4.23434084220156E-17   1.01995350483173E-22
      9.14398549751637E-11   9.14398973186741E-11  -1.29790539475676E-18  -8.03813923925216E-03  -8.03813923925418E-03
      0.00000000000000E+00   0.00000000000000E+00   2.02505963928445E-12   0.00000000000000E+00   2.02505963928445E-12
      5.38848766322124E-18  -3.70375152338909E-01  -3.70345708447302E-01   0.00000000000000E+00  -7.49105506272862E-14
     -1.27528314523961E-22  -9.33900464072036E-11  -9.34649569579584E-11  -4.09058226846448E-18
      1.09412808016914E-06
      0.00000000000000E+00  -1.10029995174617E-13   0.00000000000000E+00   3.70226465006155E-16   1.11009500590466E-22
      1.10008662338779E-10   1.10009032565355E-10  -1.28483936666103E-18  -1.32266605696287E-02  -1.32266605696280E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.16178894887692E-13   0.00000000000000E+00  -7.16178894887692E-13
      5.38490676874680E-18  -3.80719033893126E-01  -3.80684603977584E-01   0.00000000000000E+00  -4.37412786686099E-14
     -1.28012063912988E-22  -1.09249112391670E-10  -1.09292853670467E-10  -4.10006740208577E-18
      1.09912808016914E-06
      0.00000000000000E+00  -1.55125761143513E-13   0.00000000000000E+00   8.19395166467478E-16   1.27737949209943E-22
      1.55101948258177E-10   1.55102767653471E-10  -1.25757428400050E-18  -2.43867215726696E-02  -2.43867215726634E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.16139403122596E-12   0.00000000000000E+00  -6.16139403122596E-12
      5.35409979859067E-18  -3.90385154719999E-01  -3.90338234634600E-01   0.00000000000000E+00   1.60744163234846E-14
     -1.27813229795468E-22  -1.48957448038441E-10  -1.48941373622245E-10  -4.09652551459017E-18
      1.10412808016914E-06
      0.00000000000000E+00  -2.59461382611263E-13   0.00000000000000E+00   1.59716646411454E-15   1.50030204760030E-22
      2.59514661898377E-10   2.59516259064991E-10  -1.21212259499193E-18  -4.28884864505360E-02  -4.28884864505225E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.34380497655810E-11   0.00000000000000E+00  -1.34380497655810E-11
      5.28690954976277E-18  -3.99133608618600E-01  -3.99056087930756E-01   0.00000000000000E+00   8.43973863090981E-14
     -1.26833606546164E-22  -2.46162606685592E-10  -2.46078209299410E-10  -4.07478695477083E-18
      1.10912808016914E-06
      0.00000000000000E+00  -4.69785830816499E-13   0.00000000000000E+00   2.64890283120638E-15   1.69268227464002E-22
      4.69775305192185E-10   4.69777954095185E-10  -1.15541619267956E-18  -6.58421528317811E-02  -6.58421528317619E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.91985733333065E-11   0.00000000000000E+00  -1.91985733333065E-11
      5.19091668309623E-18  -4.06500353383157E-01  -4.06358409012943E-01   0.00000000000000E+00   1.20338853903603E-13
     -1.25430543831384E-22  -4.50699719615657E-10  -4.50579380761879E-10  -4.03550049041667E-18
      1.11412808016913E-06
      0.00000000000000E+00  -8.44787892834831E-13   0.00000000000000E+00   4.33184054024671E-15   1.83106875056167E-22
      8.44785679399545E-10   8.44790011240269E-10  -1.09721326112834E-18  -8.99290961460462E-02  -8.99290961460234E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.27571149349416E-11   0.00000000000000E+00  -2.27571149349416E-11
      5.07713110842153E-18  -4.11761913158614E-01  -4.11502949615654E-01   0.00000000000000E+00   1.28946215358365E-13
     -1.23899244064803E-22  -8.22161842520562E-10  -8.22032896305327E-10  -3.97991784729318E-18
      1.11912808016913E-06
      0.00000000000000E+00  -1.44719752417900E-12   0.00000000000000E+00   6.46584249365750E-15   1.93596478672432E-22
      1.44714477463027E-09   1.44715124047296E-09  -1.04308410190152E-18  -1.13546296844963E-01  -1.13546296844937E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.54180755893855E-11   0.00000000000000E+00  -2.54180755893855E-11
      4.95004073047460E-18  -4.13939454311878E-01  -4.13491565499267E-01   0.00000000000000E+00   1.32516192203269E-13
     -1.22286793263911E-22  -1.42186568107565E-09  -1.42173316488357E-09  -3.90695662857308E-18
      1.12412808016913E-06
      0.00000000000000E+00  -2.32808039873639E-12   0.00000000000000E+00   9.14715077778091E-15   2.01843859192423E-22
      2.32810841998379E-09   2.32811756713477E-09  -9.94574667748445E-19  -1.36227268329994E-01  -1.36227268329966E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.81325657609779E-11   0.00000000000000E+00  -2.81325657609779E-11
      4.80937790166971E-18  -4.11862361224451E-01  -4.11137791918266E-01   0.00000000000000E+00   1.42040505145253E-13
     -1.20509459283791E-22  -2.30012704187881E-09  -2.29998500137379E-09  -3.81480323392127E-18
      1.12912808016913E-06
      0.00000000000000E+00  -3.51159168239258E-12   0.00000000000000E+00   1.20723173235388E-14   2.07560874031949E-22
      3.51160864973135E-09   3.51162072204888E-09  -9.51367468420561E-19  -1.57878015147575E-01  -1.57878015147544E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.10171774664478E-11   0.00000000000000E+00  -3.10171774664478E-11
      4.65429201433747E-18  -4.04301681976546E-01  -4.03205171891929E-01   0.00000000000000E+00   1.60875194105035E-13
     -1.18437736860184E-22  -3.48076441977642E-09  -3.48060354458244E-09  -3.70292454591691E-18
      1.13412808016913E-06
      0.00000000000000E+00  -4.99001641722214E-12   0.00000000000000E+00   1.49313616468828E-14   2.10051880149683E-22
      4.98997302973829E-09   4.98998796110015E-09  -9.12585175339898E-19  -1.78500338901922E-01  -1.78500338901888E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.38072491203883E-11   0.00000000000000E+00  -3.38072491203883E-11
      4.48525576873553E-18  -3.90119586592765E-01  -3.88558205623978E-01   0.00000000000000E+00   1.89471185862261E-13
     -1.15922992078801E-22  -4.95637018316550E-09  -4.95618071197976E-09  -3.57267059339563E-18
      1.13912808016913E-06
      0.00000000000000E+00  -6.73194370310009E-12   0.00000000000000E+00   1.74919226986270E-14   2.08929836186165E-22
      6.73196754173604E-09   6.73198503365894E-09  -8.77318908856326E-19  -1.98128549220471E-01  -1.98128549220435E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.62218141173721E-11   0.00000000000000E+00  -3.62218141173721E-11
      4.30414669814867E-18  -3.68376601021470E-01  -3.66267165658623E-01   0.00000000000000E+00   2.26168455848014E-13
     -1.12811532868755E-22  -6.69598938799731E-09  -6.69576321954158E-09  -3.42682778929234E-18
      1.14412808016913E-06
      0.00000000000000E+00  -8.69108379247384E-12   0.00000000000000E+00   1.95995511224642E-14   2.04565830745312E-22
      8.69101063834912E-09   8.69103023790044E-09  -8.44808387683292E-19  -2.16806763522379E-01  -2.16806763522341E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.81000887788999E-11   0.00000000000000E+00  -3.81000887788999E-11
      4.11364625425417E-18  -3.38399484318778E-01  -3.35673429731674E-01   0.00000000000000E+00   2.66217002565744E-13
     -1.08955373360917E-22  -8.65319636612401E-09  -8.65293014912155E-09  -3.26883786657087E-18
      1.14912808016913E-06
      0.00000000000000E+00  -1.07998389587587E-11   0.00000000000000E+00   2.10543038254133E-14   1.98089991464243E-22
      1.07998377198455E-08   1.07998587741495E-08  -8.14488422534991E-19  -2.34580047586245E-01  -2.34580047586206E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.94956058489552E-11   0.00000000000000E+00  -3.94956058489552E-11
      3.91616822500939E-18  -2.99877253509148E-01  -2.96487217760779E-01   0.00000000000000E+00   2.99228004255119E-13
     -1.04203319608560E-22  -1.07606623963047E-08  -1.07603631683005E-08  -3.10167980247440E-18
      1.15412808016913E-06
      0.00000000000000E+00  -1.29271467619594E-11   0.00000000000000E+00   2.12160753216849E-14   1.89765650971583E-22
      1.29271392887945E-08   1.29271605048700E-08  -7.86041297261818E-19  -2.51490145761811E-01  -2.51490145761770E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.08864534753752E-11   0.00000000000000E+00  -4.08864534753752E-11
      3.71173595763252E-18  -2.53147608492230E-01  -2.49087748074153E-01   0.00000000000000E+00   3.06740245757128E-13
     -9.83925139239721E-23  -1.28865807916403E-08  -1.28862740513947E-08  -2.92569466037070E-18
      1.15912808016913E-06
      0.00000000000000E+00  -1.47951768720233E-11   0.00000000000000E+00   1.85996417983888E-14   1.74549395038002E-22
      1.47952003028341E-08   1.47952189024761E-08  -7.59472628391244E-19  -2.67572232250295E-01  -2.67572232250252E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.33402524247283E-11   0.00000000000000E+00  -4.33402524247283E-11
      3.49503469550887E-18  -1.99825662491503E-01  -1.95177975095397E-01   0.00000000000000E+00   2.71354747030526E-13
     -9.17694299148821E-23  -1.47521500047983E-08  -1.47518786500514E-08  -2.73556206711763E-18
      1.16412808016913E-06
      0.00000000000000E+00  -1.61047909798654E-11   0.00000000000000E+00   1.31071565792838E-14   1.44922848166808E-22
      1.61047978319351E-08   1.61048109390918E-08  -7.34792643130616E-19  -2.82861322581259E-01  -2.82861322581213E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.65946198151792E-11   0.00000000000000E+00  -4.65946198151792E-11
      3.26206159643298E-18  -1.42833811007581E-01  -1.37774499876673E-01   0.00000000000000E+00   2.09724791470871E-13
     -8.58197558654073E-23  -1.60584260440680E-08  -1.60582163192766E-08  -2.52726895330236E-18
      1.16912808016913E-06
      0.00000000000000E+00  -1.65241540499550E-11   0.00000000000000E+00   4.30699251043132E-15   1.01182737814619E-22
      1.65241398229462E-08   1.65241441299389E-08  -7.11728081456392E-19  -2.97402102853370E-01  -2.97402102853322E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.82888856666848E-11   0.00000000000000E+00  -4.82888856666848E-11
      3.02061716809955E-18  -8.65264168481403E-02  -8.13354833654394E-02   0.00000000000000E+00   1.59742488127371E-13
     -7.73529841445425E-23  -1.64760149867602E-08  -1.64758552442722E-08  -2.30888908664316E-18
      1.17412808016913E-06
      0.00000000000000E+00  -1.44180623810492E-11   0.00000000000000E+00  -2.06390790757648E-14   5.10345843508209E-23
      1.44181384256268E-08   1.44181177865478E-08  -6.89119807964858E-19  -3.11255256225037E-01  -3.11255256224992E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.46033603655395E-11   0.00000000000000E+00  -4.46033603655395E-11
      2.79760036627186E-18  -4.28152700354718E-02  -3.82866827527351E-02   0.00000000000000E+00   1.24219151541870E-13
     -4.86934041609890E-23  -1.43736386453337E-08  -1.43735144261822E-08  -2.10848055830700E-18
      1.17912808016913E-06
      0.00000000000000E+00  -1.02955195067521E-11   0.00000000000000E+00  -4.02252104544399E-14   2.26327220607384E-23
      1.02955053115708E-08   1.02954650863603E-08  -6.63830854767360E-19  -3.24494479067839E-01  -3.24494479067807E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.21463900407123E-11   0.00000000000000E+00  -3.21463900407123E-11
      2.63686841606829E-18  -2.06417339327726E-02  -1.74081154889777E-02   0.00000000000000E+00   9.22386438148306E-14
     -2.26266462594934E-23  -1.02634109349634E-08  -1.02633186963196E-08  -1.97303756130093E-18
      1.18412808016913E-06
      0.00000000000000E+00  -7.65516700151015E-12   0.00000000000000E+00  -2.58841800158843E-14   1.18063720228184E-23
      7.65519742409565E-09   7.65517153991564E-09  -6.36525465833195E-19  -3.37134245776395E-01  -3.37134245776372E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.25368822960747E-11   0.00000000000000E+00  -2.25368822960747E-11
      2.52418400458792E-18  -1.19781935750224E-02  -9.57340938276063E-03   0.00000000000000E+00   5.38007662062037E-14
     -1.24833885251661E-23  -7.63268845838577E-09  -7.63263465761957E-09  -1.88765853875472E-18
      1.18912808016913E-06
      0.00000000000000E+00  -6.61438243947445E-12   0.00000000000000E+00  -8.84917030005705E-15   7.70819616945799E-24
      6.61434543049245E-09   6.61433658132216E-09  -6.08914773835924E-19  -3.49175474152746E-01  -3.49175474152728E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.82272186770145E-11   0.00000000000000E+00  -1.82272186770145E-11
      2.43304791120285E-18  -8.62915610698880E-03  -6.55094408534748E-03   0.00000000000000E+00   2.78542768143013E-14
     -8.68031319195726E-24  -6.59613721692195E-09  -6.59610936264515E-09  -1.82413313736692E-18
      1.19412808016913E-06
      0.00000000000000E+00  -6.26886253809974E-12   0.00000000000000E+00  -3.27120959259463E-15   5.78449193130090E-24
      6.26885027771426E-09   6.26884700650467E-09  -5.81799290607019E-19  -3.60629200972020E-01  -3.60629200972003E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.63880908597678E-11   0.00000000000000E+00  -1.63880908597678E-11
      2.35110745690401E-18  -7.06104977326993E-03  -5.09110836742354E-03   0.00000000000000E+00   1.86427840612744E-14
     -6.84577361154720E-24  -6.25247755842896E-09  -6.25245891564491E-09  -1.76930816629699E-18
      1.19912808016913E-06
      0.00000000000000E+00  -6.14845408762067E-12   0.00000000000000E+00  -1.06403980673921E-15   4.64262853763092E-24
      6.14846738523533E-09   6.14846632119553E-09  -5.55522063646338E-19  -3.71504037811175E-01  -3.71504037811159E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53990673953149E-11   0.00000000000000E+00  -1.53990673953149E-11
      2.27411211992744E-18  -6.12888277133168E-03  -4.19655626984432E-03   0.00000000000000E+00   1.43144358554621E-14
     -5.68155413840987E-24  -6.13308156823607E-09  -6.13306725380022E-09  -1.71859005628110E-18
      1.20412808016913E-06
      0.00000000000000E+00  -6.09509229530310E-12   0.00000000000000E+00  -4.15787703877392E-16   3.86938866807921E-24
      6.09505270087694E-09   6.09505228508924E-09  -5.30339277805452E-19  -3.81781874933528E-01  -3.81781874933513E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.46653925471621E-11   0.00000000000000E+00  -1.46653925471621E-11
      2.20078515719162E-18  -5.48782890099659E-03  -3.57209899146885E-03   0.00000000000000E+00   1.20433646955628E-14
     -4.84671577728819E-24  -6.08039893590677E-09  -6.08038689254208E-09  -1.67044587938617E-18
      1.20912808016913E-06
      0.00000000000000E+00  -6.06349770570371E-12   0.00000000000000E+00  -2.12212125311770E-16   3.31701199456877E-24
      6.06353321499675E-09   6.06353300278462E-09  -5.06643623960569E-19  -3.91365403534650E-01  -3.91365403534636E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.38895260073121E-11   0.00000000000000E+00  -1.38895260073121E-11
      2.13133752715506E-18  -5.02093291331343E-03  -3.11488815962009E-03   0.00000000000000E+00   1.03725684374013E-14
     -4.22342487972951E-24  -6.04965384934574E-09  -6.04964347677731E-09  -1.62469390319449E-18
      1.21412808016913E-06
      0.00000000000000E+00  -6.04044467666462E-12   0.00000000000000E+00  -1.41909407157498E-16   2.91727163188447E-24
      6.04047447774649E-09   6.04047433583709E-09  -4.85198042058324E-19  -3.99993538567566E-01  -3.99993538567553E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.27439568799502E-11   0.00000000000000E+00  -1.27439568799502E-11
      2.06761774275531E-18  -4.67849472220128E-03  -2.77935315152284E-03   0.00000000000000E+00   8.77227723333110E-15
     -3.76292066372425E-24  -6.02773915123436E-09  -6.02773037895714E-09  -1.58241970069699E-18
      1.21912808016913E-06
      0.00000000000000E+00  -6.02051436869059E-12   0.00000000000000E+00  -1.28668800215042E-16   2.63434637219812E-24
      6.02053965655315E-09   6.02053952788435E-09  -4.67303719607894E-19  -4.07175898738612E-01  -4.07175898738601E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08118981251999E-11   0.00000000000000E+00  -1.08118981251999E-11
      2.01355825212931E-18  -4.43628640781453E-03  -2.54281618951230E-03   0.00000000000000E+00   6.95908166668550E-15
     -3.44376006457498E-24  -6.00973458884081E-09  -6.00972762975915E-09  -1.54625453252142E-18
      1.22412808016913E-06
      0.00000000000000E+00  -6.00049221597935E-12   0.00000000000000E+00  -9.81180489035637E-17   2.45025887327855E-24
      6.00053106039856E-09   6.00053096228051E-09  -4.54877283101800E-19  -4.12160815177228E-01  -4.12160815177221E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.62473059125490E-12   0.00000000000000E+00  -7.62473059125490E-12
      1.97543459917304E-18  -4.28408271855211E-03  -2.39591191223942E-03   0.00000000000000E+00   4.64920827247896E-15
     -3.26191611288703E-24  -5.99291088089753E-09  -5.99290623168926E-09  -1.52055731607124E-18
      1.22912808016913E-06
      0.00000000000000E+00  -5.97753103167746E-12   0.00000000000000E+00  -2.10248159088325E-16   2.35996964422206E-24
      5.97757626969973E-09   5.97757605945157E-09  -4.50430213921254E-19  -4.13944881200971E-01  -4.13944881200968E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.75936742513431E-12   0.00000000000000E+00  -2.75936742513431E-12
      1.96163776204737E-18  -4.22374090645449E-03  -2.34126934058492E-03   0.00000000000000E+00   1.77377962907066E-15
     -3.23361099345464E-24  -5.97481846580606E-09  -5.97481669202643E-09  -1.51120754812611E-18
      1.23412808016913E-06
      0.00000000000000E+00  -5.94795702629664E-12   0.00000000000000E+00  -3.15526953338563E-16   2.37192777718161E-24
      5.94794681996803E-09   5.94794650444108E-09  -4.56912641942475E-19  -4.11343993072979E-01  -4.11343993072983E-01
      0.00000000000000E+00   0.00000000000000E+00   3.99397365643322E-12   0.00000000000000E+00   3.99397365643322E-12
      1.98160763032953E-18  -4.27371487301446E-03  -2.39845109960683E-03   0.00000000000000E+00  -2.08460266919484E-15
     -3.41064852784799E-24  -5.95193839349484E-09  -5.95194047809751E-09  -1.52469498838706E-18
      1.23912808016913E-06
      0.00000000000000E+00  -5.90497368928352E-12   0.00000000000000E+00  -4.99869913575193E-16   2.51414840966850E-24
      5.90495941133441E-09   5.90495891146450E-09  -4.77383084569489E-19  -4.03132230335120E-01  -4.03132230335133E-01
      0.00000000000000E+00   0.00000000000000E+00   1.24461704035395E-11   0.00000000000000E+00   1.24461704035395E-11
      2.04383848234723E-18  -4.48407831991975E-03  -2.61969631783476E-03   0.00000000000000E+00  -7.21197709029972E-15
     -3.92372809650587E-24  -5.91739786989094E-09  -5.91740508186803E-09  -1.56645539777774E-18
      1.24412808016913E-06
      0.00000000000000E+00  -5.83324294952444E-12   0.00000000000000E+00  -5.83783542250241E-14   2.84871305392074E-24
      5.83317574392898E-09   5.83311736557476E-09  -5.14537403297870E-19  -3.88188634126136E-01  -3.88188634126158E-01
      0.00000000000000E+00   0.00000000000000E+00   2.20009121465932E-11   0.00000000000000E+00   2.20009121465932E-11
      2.15384304308020E-18  -4.97856472286871E-03  -3.13379070438356E-03   0.00000000000000E+00   4.33162965660629E-14
     -5.10842416497105E-24  -5.85516159401792E-09  -5.85511827772136E-09  -1.63930563978233E-18
      1.24912808016913E-06
      0.00000000000000E+00  -5.69143467527602E-12   0.00000000000000E+00  -1.64054404082811E-15   3.49594045223597E-24
      5.69147445168981E-09   5.69147281114577E-09  -5.69968096071173E-19  -3.65599071218108E-01  -3.65599071218140E-01
      0.00000000000000E+00   0.00000000000000E+00   3.20082389553201E-11   0.00000000000000E+00   3.20082389553201E-11
      2.31388423785680E-18  -6.07318164799096E-03  -4.26990282170357E-03   0.00000000000000E+00  -2.37374011327184E-14
     -7.88015148370712E-24  -5.72345731269995E-09  -5.72348105010109E-09  -1.74391614178562E-18
      1.25412808016913E-06
      0.00000000000000E+00  -5.36814120030552E-12   0.00000000000000E+00  -4.41727957679346E-15   4.63692156185633E-24
      5.36815193318068E-09   5.36814751590111E-09  -6.42882982799308E-19  -3.34722595219971E-01  -3.34722595220014E-01
      0.00000000000000E+00   0.00000000000000E+00   4.27229157520360E-11   0.00000000000000E+00   4.27229157520360E-11
      2.52749881661698E-18  -8.59755222698169E-03  -6.89277015154088E-03   0.00000000000000E+00  -3.63839418498782E-14
     -1.47112632445845E-23  -5.41083404771128E-09  -5.41087043165315E-09  -1.88461583381767E-18
      1.25912808016913E-06
      0.00000000000000E+00  -4.61262639203641E-12   0.00000000000000E+00  -7.98512120798693E-15   6.25273134976416E-24
      4.61259040545420E-09   4.61258242033299E-09  -7.29068685933739E-19  -2.95297906356837E-01  -2.95297906356893E-01
      0.00000000000000E+00   0.00000000000000E+00   5.63524819874960E-11   0.00000000000000E+00   5.63524819874960E-11
      2.80926122655446E-18  -1.45199838278111E-02  -1.30489657423920E-02   0.00000000000000E+00  -5.62142302022512E-14
     -3.05966800029842E-23  -4.66887868809025E-09  -4.66893490232049E-09  -2.08019254062072E-18
      1.26412808016913E-06
      0.00000000000000E+00  -3.18012402581061E-12   0.00000000000000E+00  -1.48427424458606E-14   6.54178864105301E-24
      3.18014115793722E-09   3.18012631519478E-09  -8.23575701162005E-19  -2.47763824043234E-01  -2.47763824043307E-01
      0.00000000000000E+00   0.00000000000000E+00   7.36596338841512E-11   0.00000000000000E+00   7.36596338841512E-11
      3.17755939597521E-18  -2.68711071545821E-02  -2.58459581198701E-02   0.00000000000000E+00  -8.43542768972263E-14
     -5.70790986671844E-23  -3.25370159480197E-09  -3.25378594907893E-09  -2.35398369481321E-18
      1.26912808016913E-06
      0.00000000000000E+00  -1.54069546665626E-12   0.00000000000000E+00  -1.73197253693004E-14  -2.68478256420304E-25
      1.54070864126046E-09   1.54069132153509E-09  -9.25876160077722E-19  -1.93901510155980E-01  -1.93901510156067E-01
      0.00000000000000E+00   0.00000000000000E+00   8.65899208508248E-11   0.00000000000000E+00   8.65899208508248E-11
      3.61050900022934E-18  -4.63448538836272E-02  -4.58321604962282E-02   0.00000000000000E+00  -1.29371315928197E-13
     -7.98058317425196E-23  -1.62715187106991E-09  -1.62728124238592E-09  -2.68463284015161E-18
      1.27412808016913E-06
      0.00000000000000E+00  -5.33158699489693E-13   0.00000000000000E+00  -1.10720603887103E-14  -1.53096849105271E-23
      5.33163740780725E-10   5.33152668720321E-10  -1.03792026812579E-18  -1.36719974548716E-01  -1.36719974548804E-01
      0.00000000000000E+00   0.00000000000000E+00   8.77694239699585E-11   0.00000000000000E+00   8.77694239699585E-11
      4.04935612007913E-18  -6.96579273797942E-02  -6.94623005360268E-02   0.00000000000000E+00  -1.94093318057247E-13
     -8.99629993836195E-23  -6.20727999372132E-10  -6.20922092690279E-10  -3.01143585195334E-18
      1.27912808016913E-06
      0.00000000000000E+00  -1.45482063736722E-13   0.00000000000000E+00  -5.14407502246287E-15  -2.96780842571838E-23
      1.45489104960625E-10   1.45483960885573E-10  -1.15424466642297E-18  -8.09860591213899E-02  -8.09860591214679E-02
      0.00000000000000E+00   0.00000000000000E+00   7.80932870822206E-11   0.00000000000000E+00   7.80932870822206E-11
      4.43982255549023E-18  -9.37371538254383E-02  -9.36667144704203E-02   0.00000000000000E+00  -2.67939381106346E-13
     -9.60977263041613E-23  -2.23309308586592E-10  -2.23577247967794E-10  -3.28557788906725E-18
      1.28412808016913E-06
      0.00000000000000E+00  -4.86777107199892E-14   0.00000000000000E+00  -2.01120669370413E-15  -3.50832042888114E-23
      4.85902584700817E-11   4.85882472633529E-11  -1.24452064656097E-18  -3.94980545263008E-02  -3.94980545263576E-02
      0.00000000000000E+00   0.00000000000000E+00   5.67238830014267E-11   0.00000000000000E+00   5.67238830014267E-11
      4.72344197049737E-18  -1.17220399627138E-01  -1.17187220621787E-01   0.00000000000000E+00  -2.84195482108423E-13
     -1.01564105902066E-22  -1.05027934782569E-10  -1.05312130264779E-10  -3.47892132393640E-18
      1.28912808016913E-06
      0.00000000000000E+00  -3.71971185690483E-14   0.00000000000000E+00  -6.28452435643413E-16  -3.15525736471699E-23
      3.71978155081377E-11   3.71971870556705E-11  -1.29013438100154E-18  -1.92693035035835E-02  -1.92693035036164E-02
      0.00000000000000E+00   0.00000000000000E+00   3.28949815344549E-11   0.00000000000000E+00   3.28949815344549E-11
      4.88791687816964E-18  -1.39740013001144E-01  -1.39717930345444E-01   0.00000000000000E+00  -2.18295486516947E-13
     -1.05312875488789E-22  -6.98738731035035E-11  -7.00921685901257E-11  -3.59778249716810E-18
      1.29412808016913E-06
      0.00000000000000E+00  -4.04116843713118E-14   0.00000000000000E+00  -1.14920532607081E-16  -1.96780511781407E-23
      4.04559839551913E-11   4.04558690346390E-11  -1.30795203628989E-18  -1.14648584470433E-02  -1.14648584470619E-02
      0.00000000000000E+00   0.00000000000000E+00   1.86490673363905E-11   0.00000000000000E+00   1.86490673363905E-11
      4.98116221485159E-18  -1.61225820188964E-01  -1.61207199241010E-01   0.00000000000000E+00  -1.65971041375077E-13
     -1.07916480295454E-22  -5.89389653295464E-11  -5.91049363710294E-11  -3.67321017856170E-18
      1.29912808016913E-06
      0.00000000000000E+00  -4.44528528084430E-14   0.00000000000000E+00  -3.17155798837564E-18   1.18219076725145E-25
      4.44745252583167E-11   4.44745220867589E-11  -1.31416170825356E-18  -8.41034965117608E-03  -8.41034965118821E-03
      0.00000000000000E+00   0.00000000000000E+00   1.21282354561961E-11   0.00000000000000E+00   1.21282354561961E-11
      5.04180339213257E-18  -1.81687327818651E-01  -1.81669495307274E-01   0.00000000000000E+00  -1.45030487124638E-13
     -1.10053897914524E-22  -5.64577270557204E-11  -5.66027575429551E-11  -3.72764168387902E-18
      1.30412808016913E-06
      0.00000000000000E+00  -4.77592633479139E-14   0.00000000000000E+00   3.20696275956595E-17   2.29165430904845E-23
      4.77758131267860E-11   4.77758451964365E-11  -1.31617080219278E-18  -6.94156867221443E-03  -6.94156867222367E-03
      0.00000000000000E+00   0.00000000000000E+00   9.23444414914942E-12   0.00000000000000E+00   9.23444414914942E-12
      5.08797561287832E-18  -2.01161414208569E-01  -2.01143453427353E-01   0.00000000000000E+00  -1.37430699594649E-13
     -1.11978267951731E-22  -5.68728586458793E-11  -5.70102893455859E-11  -3.77180481068554E-18
      1.30912808016913E-06
      0.00000000000000E+00  -5.06064502013472E-14   0.00000000000000E+00   3.28844943223810E-17   4.29996939587141E-23
      5.06498114567059E-11   5.06498443412432E-11  -1.31664557097226E-18  -6.05012455777519E-03  -6.05012455778299E-03
      0.00000000000000E+00   0.00000000000000E+00   7.80891501722509E-12   0.00000000000000E+00   7.80891501722509E-12
      5.12702018796444E-18  -2.19692740007108E-01  -2.19674323005508E-01   0.00000000000000E+00  -1.32943824138891E-13
     -1.13758284943917E-22  -5.83258155342160E-11  -5.84587593584686E-11  -3.81037461699219E-18
      1.31412808016913E-06
      0.00000000000000E+00  -5.33617923175730E-14   0.00000000000000E+00   3.34680809792826E-17   5.81274442665338E-23
      5.33895215106450E-11   5.33895549787842E-11  -1.31647581791755E-18  -5.43125946505131E-03  -5.43125946505829E-03
      0.00000000000000E+00   0.00000000000000E+00   6.98295142824767E-12   0.00000000000000E+00   6.98295142824767E-12
      5.16193494510569E-18  -2.37326092888050E-01  -2.37307073086858E-01   0.00000000000000E+00  -1.28689271102543E-13
     -1.15419176275427E-22  -6.02438171358133E-11  -6.03725064070312E-11  -3.84545912718814E-18
      1.31912808016913E-06
      0.00000000000000E+00  -5.61171344337988E-14   0.00000000000000E+00   3.52976683779211E-17   6.85273716625692E-23
      5.61307047881660E-11   5.61307400859029E-11  -1.31597160950249E-18  -4.97929560278200E-03  -4.97929560278842E-03
      0.00000000000000E+00   0.00000000000000E+00   6.42160310815355E-12   0.00000000000000E+00   6.42160310815355E-12
      5.19404296064645E-18  -2.54102339469713E-01  -2.54082633044802E-01   0.00000000000000E+00  -1.24275005521125E-13
     -1.16979693948021E-22  -6.24280681884186E-11  -6.25523431940567E-11  -3.87807135114396E-18
      1.32412808016913E-06
      0.00000000000000E+00  -5.88724765500246E-14   0.00000000000000E+00   3.75835042056653E-17   7.55050677133015E-23
      5.89176834979851E-11   5.89177210815648E-11  -1.31525435208873E-18  -4.64834025582598E-03  -4.64834025583197E-03
      0.00000000000000E+00   0.00000000000000E+00   5.98505894357832E-12   0.00000000000000E+00   5.98505894357832E-12
      5.22396825536434E-18  -2.70055706754773E-01  -2.70035259965762E-01   0.00000000000000E+00  -1.19800542739027E-13
     -1.18454748635591E-22  -6.47829794822857E-11  -6.49027800251431E-11  -3.90871390327561E-18
      1.32912808016913E-06
      0.00000000000000E+00  -6.17196634034580E-14   0.00000000000000E+00   3.99354054255390E-17   8.03477108712526E-23
      6.17630502090258E-11   6.17630901445116E-11  -1.31437553946437E-18  -4.41595324302674E-03  -4.41595324303236E-03
      0.00000000000000E+00   0.00000000000000E+00   5.61119327525344E-12   0.00000000000000E+00   5.61119327525344E-12
      5.25202422174061E-18  -2.85222701209866E-01  -2.85201475920886E-01   0.00000000000000E+00  -1.15434325407019E-13
     -1.19855134301075E-22  -6.72588490942383E-11  -6.73742834197652E-11  -3.93764868227625E-18
      1.33412808016913E-06
      0.00000000000000E+00  -6.46586949940988E-14   0.00000000000000E+00   4.21409585670784E-17   8.39630769290226E-23
      6.46796529426032E-11   6.46796950836458E-11  -1.31335175998021E-18  -4.27317209664306E-03  -4.27317209664833E-03
      0.00000000000000E+00   0.00000000000000E+00   5.27128805619108E-12   0.00000000000000E+00   5.27128805619108E-12
      5.27838066202157E-18  -2.99649000533703E-01  -2.99626963607994E-01   0.00000000000000E+00  -1.11322463951017E-13
     -1.21189139438295E-22  -6.98396606757644E-11  -6.99509831398366E-11  -3.96502890204135E-18
      1.33912808016913E-06
      0.00000000000000E+00  -6.76895713219472E-14   0.00000000000000E+00   4.56619006455310E-17   8.69125135264006E-23
      6.77011009214537E-11   6.77011465834413E-11  -1.31216978939032E-18  -4.22327571263052E-03  -4.22327571263547E-03
      0.00000000000000E+00   0.00000000000000E+00   4.95283544244634E-12   0.00000000000000E+00   4.95283544244634E-12
      5.30314483923380E-18  -3.13400794927372E-01  -3.13377906580252E-01   0.00000000000000E+00  -1.07633330141172E-13
     -1.22464691824308E-22  -7.25463486956243E-11  -7.26539820258879E-11  -3.99097504984348E-18
      1.34412808016913E-06
      0.00000000000000E+00  -7.09041371242107E-14   0.00000000000000E+00   5.04235412288087E-17   8.95360098565222E-23
      7.08995077421895E-11   7.08995581658203E-11  -1.31077622449778E-18  -4.28708592515831E-03  -4.28708592516294E-03
      0.00000000000000E+00   0.00000000000000E+00   4.63774297572392E-12   0.00000000000000E+00   4.63774297572392E-12
      5.32633355411242E-18  -3.26544855406991E-01  -3.26521058835600E-01   0.00000000000000E+00  -1.04265965734525E-13
     -1.23687252913424E-22  -7.54330351756857E-11  -7.55373011415439E-11  -4.01555732961463E-18
      1.34912808016913E-06
      0.00000000000000E+00  -7.43942371380967E-14   0.00000000000000E+00   5.85596282960634E-17   9.20664893485596E-23
      7.44201277878857E-11   7.44201863476061E-11  -1.30904347857895E-18  -4.51974608600894E-03  -4.51974608601322E-03
      0.00000000000000E+00   0.00000000000000E+00   4.27638201522132E-12   0.00000000000000E+00   4.27638201522132E-12
      5.34771546418852E-18  -3.39089064024719E-01  -3.39064272301858E-01   0.00000000000000E+00  -1.00381820659430E-13
     -1.24851994096354E-22  -7.85961865420435E-11  -7.86965683628278E-11  -4.03867198560957E-18
      1.35412808016913E-06
      0.00000000000000E+00  -7.86190950496429E-14   0.00000000000000E+00   7.50376695963311E-17   9.47781077964710E-23
      7.86281859828835E-11   7.86282610206479E-11  -1.30665741005574E-18  -5.05761376086070E-03  -5.05761376086449E-03
      0.00000000000000E+00   0.00000000000000E+00   3.79881147397502E-12   0.00000000000000E+00   3.79881147397502E-12
      5.36670952155840E-18  -3.51035979087365E-01  -3.51010012262605E-01   0.00000000000000E+00  -9.51637797766325E-14
     -1.25944781217777E-22  -8.23319087147200E-11  -8.24270724946226E-11  -4.06005211150267E-18
      1.35912808016913E-06
      0.00000000000000E+00  -8.44971582309246E-14   0.00000000000000E+00   1.13453767926832E-16   9.82303885251748E-23
      8.45170333965533E-11   8.45171468504195E-11  -1.30280932856635E-18  -6.25062952123336E-03  -6.25062952123639E-03
      0.00000000000000E+00   0.00000000000000E+00   3.03077749641951E-12   0.00000000000000E+00   3.03077749641951E-12
      5.38186340904050E-18  -3.62397386726239E-01  -3.62369806809379E-01   0.00000000000000E+00  -8.66098743729971E-14
     -1.26928915741357E-22  -8.74613144723389E-11  -8.75479243468388E-11  -4.07905408047414E-18
      1.36412808016913E-06
      0.00000000000000E+00  -9.49674582725827E-14   0.00000000000000E+00   2.11338459154073E-16   1.03823500798533E-22
      9.49709864266618E-11   9.49711977652248E-11  -1.29536903671259E-18  -9.01576912525117E-03  -9.01576912525266E-03
      0.00000000000000E+00   0.00000000000000E+00   1.49559362649922E-12   0.00000000000000E+00   1.49559362649922E-12
      5.38934137717299E-18  -3.73179697782350E-01  -3.73149308310229E-01   0.00000000000000E+00  -6.90931962113370E-14
     -1.27704559018148E-22  -9.63976981953847E-11  -9.64667913917238E-11  -4.09397234046040E-18
      1.36912808016913E-06
      0.00000000000000E+00  -1.18296021523294E-13   0.00000000000000E+00   4.59853822528420E-16   1.14596523799639E-22
      1.18323537233345E-10   1.18323997087282E-10  -1.27932258122130E-18  -1.54743503869747E-02  -1.54743503869729E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.86304840925302E-12   0.00000000000000E+00  -1.86304840925302E-12
      5.38002613512673E-18  -3.83356792709697E-01  -3.83320104697129E-01   0.00000000000000E+00  -3.07532359332035E-14
     -1.28039065315552E-22  -1.16430195441968E-10  -1.16460948678029E-10  -4.10070355390543E-18
      1.37412808016913E-06
      0.00000000000000E+00  -1.75331603329169E-13   0.00000000000000E+00   9.86391535067916E-16   1.33452413692067E-22
      1.75310828303778E-10   1.75311814695446E-10  -1.24719083100918E-18  -2.86343853780493E-02  -2.86343853780412E-02
      0.00000000000000E+00   0.00000000000000E+00  -8.04647058984014E-12   0.00000000000000E+00  -8.04647058984014E-12
      5.33979378217753E-18  -3.92811196662858E-01  -3.92758504077247E-01   0.00000000000000E+00   3.53778276142119E-14
     -1.27620433765155E-22  -1.67300721933092E-10  -1.67265344105606E-10  -4.09260295116835E-18
      1.37912808016913E-06
      0.00000000000000E+00  -3.02720253836008E-13   0.00000000000000E+00   1.87372278685168E-15   1.55686862527921E-22
      3.02715107603208E-10   3.02716981326150E-10  -1.19774457747417E-18  -4.87026413797756E-02  -4.87026413797604E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.52105644425713E-11   0.00000000000000E+00  -1.52105644425713E-11
      5.26374095996467E-18  -4.01248723099771E-01  -4.01158151400098E-01   0.00000000000000E+00   9.77297325716304E-14
     -1.26486112863269E-22  -2.87604146616024E-10  -2.87506416883579E-10  -4.06599638249050E-18
      1.38412808016913E-06
      0.00000000000000E+00  -5.50517354821915E-13   0.00000000000000E+00   3.06968053659753E-15   1.73388144690627E-22
      5.50500265155316E-10   5.50503334836026E-10  -1.13981803338016E-18  -7.22105869498506E-02  -7.22105869498303E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.03102894344122E-11   0.00000000000000E+00  -2.03102894344122E-11
      5.16218951279261E-18  -4.08138811276655E-01  -4.07971786258309E-01   0.00000000000000E+00   1.24192069256426E-13
     -1.25032007037213E-22  -5.30317237470745E-10  -5.30193045401614E-10  -4.02237147941245E-18
      1.38912808016913E-06
      0.00000000000000E+00  -9.79891501267103E-13   0.00000000000000E+00   4.80999235586743E-15   1.86137783409547E-22
      9.79860238359086E-10   9.79865048351628E-10  -1.08235230568935E-18  -9.62661181622665E-02  -9.62661181622430E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.34957038150829E-11   0.00000000000000E+00  -2.34957038150829E-11
      5.04471099371719E-18  -4.12687717379819E-01  -4.12386433564653E-01   0.00000000000000E+00   1.29783630021853E-13
     -1.23482089772077E-22  -9.56499128166443E-10  -9.56369344536544E-10  -3.96235868802784E-18
      1.39412808016913E-06
      0.00000000000000E+00  -1.65191944341458E-12   0.00000000000000E+00   7.13533766566609E-15   1.95996298890252E-22
      1.65194399681769E-09   1.65195113215555E-09  -1.02967396059983E-18  -1.19655685455135E-01  -1.19655685455109E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.61151699362068E-11   0.00000000000000E+00  -2.61151699362068E-11
      4.91413514403616E-18  -4.13856644035072E-01  -4.13344455835324E-01   0.00000000000000E+00   1.34235426693725E-13
     -1.21836867570049E-22  -1.62597019764592E-09  -1.62583596221934E-09  -3.88446118343633E-18
      1.39912808016913E-06
      0.00000000000000E+00  -2.61215617091927E-12   0.00000000000000E+00   9.91207992063485E-15   2.03635081362748E-22
      2.61212887166023E-09   2.61213878374035E-09  -9.82638333979223E-19  -1.42066897306134E-01  -1.42066897306105E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.88888799503566E-11   0.00000000000000E+00  -2.88888799503566E-11
      4.76969074428438E-18  -4.10444355486180E-01  -4.09630547133991E-01   0.00000000000000E+00   1.46076450466859E-13
     -1.19995125983285E-22  -2.58339598024034E-09  -2.58324990379000E-09  -3.78705241030515E-18
      1.40412808016913E-06
      0.00000000000000E+00  -3.87566422068321E-12   0.00000000000000E+00   1.28479600362931E-14   2.08561704875447E-22
      3.87569013463740E-09   3.87570298259765E-09  -9.40696351601518E-19  -1.63442934003652E-01  -1.63442934003620E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.17788376486844E-11   0.00000000000000E+00  -3.17788376486844E-11
      4.61079655604095E-18  -4.01232657396380E-01  -4.00021686250317E-01   0.00000000000000E+00   1.67531178397654E-13
     -1.17820907146255E-22  -3.84409167612724E-09  -3.84392414494896E-09  -3.67010020443943E-18
      1.40912808016913E-06
      0.00000000000000E+00  -5.42774843475321E-12   0.00000000000000E+00   1.56463192079886E-14   2.10108136157778E-22
      5.42769956127870E-09   5.42771520759811E-09  -9.02929884027399E-19  -1.83797781725071E-01  -1.83797781725036E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.44932297817088E-11   0.00000000000000E+00  -3.44932297817088E-11
      4.43833040713241E-18  -3.85128012764967E-01  -3.83428943317580E-01   0.00000000000000E+00   1.98537066106600E-13
     -1.15162877301114E-22  -5.39342051488240E-09  -5.39322197781641E-09  -3.53540052310501E-18
      1.41412808016913E-06
      0.00000000000000E+00  -7.23240567614390E-12   0.00000000000000E+00   1.80886953982014E-14   2.08052582305945E-22
      7.23232993143939E-09   7.23234802013500E-09  -8.68460552788508E-19  -2.03169768432278E-01  -2.03169768432241E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.67746153310398E-11   0.00000000000000E+00  -3.67746153310398E-11
      4.25445733047721E-18  -3.61255532658100E-01  -3.58988630151419E-01   0.00000000000000E+00   2.36764143711320E-13
     -1.11868080518103E-22  -7.19581016894756E-09  -7.19557340480396E-09  -3.38599677768871E-18
      1.41912808016913E-06
      0.00000000000000E+00  -9.23902949465395E-12   0.00000000000000E+00   2.00644061369012E-14   2.03003947156809E-22
      9.23902376606632E-09   9.23904383047265E-09  -8.36576934892009E-19  -2.21603816955101E-01  -2.21603816955062E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.85075189844268E-11   0.00000000000000E+00  -3.85075189844268E-11
      4.06191973555508E-18  -3.29024699344020E-01  -3.26126114514594E-01   0.00000000000000E+00   2.76283575731213E-13
     -1.07790185789979E-22  -9.20081259506384E-09  -9.20053631148822E-09  -3.22534280066307E-18
      1.42412808016913E-06
      0.00000000000000E+00  -1.13701029320802E-11   0.00000000000000E+00   2.12682408986502E-14   1.96131389985046E-22
      1.13701161063775E-08   1.13701373746186E-08  -8.06771971436983E-19  -2.39144476484810E-01  -2.39144476484770E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.98302067084213E-11   0.00000000000000E+00  -3.98302067084213E-11
      3.86276870201297E-18  -2.88255126674783E-01  -2.84685517113880E-01   0.00000000000000E+00   3.04608497797776E-13
     -1.02771135155437E-22  -1.13306117764078E-08  -1.13303071679101E-08  -3.05599673057599E-18
      1.42912808016913E-06
      0.00000000000000E+00  -1.34626015798793E-11   0.00000000000000E+00   2.08675349023740E-14   1.86798546699946E-22
      1.34626123121929E-08   1.34626331797280E-08  -7.78809577719917E-19  -2.55831975855208E-01  -2.55831975855167E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.13857345664452E-11   0.00000000000000E+00  -4.13857345664452E-11
      3.65584002918075E-18  -2.39552842852816E-01  -2.35324421342674E-01   0.00000000000000E+00   3.01812315359602E-13
     -9.66806800156026E-23  -1.34215492574768E-08  -1.34212474451616E-08  -2.87703045146083E-18
      1.43412808016913E-06
      0.00000000000000E+00  -1.52037941078596E-11   0.00000000000000E+00   1.73816756248630E-14   1.68179979410552E-22
      1.52037163461896E-08   1.52037337278654E-08  -7.52758837598408E-19  -2.71700033670989E-01  -2.71700033670945E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.42285650339931E-11   0.00000000000000E+00  -4.42285650339931E-11
      3.43469720401078E-18  -1.84945946541173E-01  -1.80169818877361E-01   0.00000000000000E+00   2.55629277448659E-13
     -9.00569519139859E-23  -1.51597607921087E-08  -1.51595051628314E-08  -2.68193836641237E-18
      1.43912808016913E-06
      0.00000000000000E+00  -1.63343109781470E-11   0.00000000000000E+00   1.31735653186934E-14   1.34675877994345E-22
      1.63342727230324E-08   1.63342858965979E-08  -7.28527326256453E-19  -2.86786296170344E-01  -2.86786296170297E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.72420234134468E-11   0.00000000000000E+00  -4.72420234134468E-11
      3.19848708694355E-18  -1.27567021168923E-01  -1.22435604270773E-01   0.00000000000000E+00   1.92897620346146E-13
     -8.44075957813112E-23  -1.62872367708047E-08  -1.62870438731844E-08  -2.46995976068710E-18
      1.44412808016913E-06
      0.00000000000000E+00  -1.63087781412033E-11   0.00000000000000E+00  -9.72393538663879E-17   8.74012475968470E-23
      1.63087548592687E-08   1.63087547620294E-08  -7.05830604290398E-19  -3.01137165943890E-01  -3.01137165943842E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.82237585192017E-11   0.00000000000000E+00  -4.82237585192017E-11
      2.95736829434754E-18  -7.29922680842686E-02  -6.78691667293079E-02   0.00000000000000E+00   1.49009753958676E-13
     -7.18908467964711E-23  -1.62606800132641E-08  -1.62605310035102E-08  -2.25153769005714E-18
      1.44912808016913E-06
      0.00000000000000E+00  -1.33422849741374E-11   0.00000000000000E+00  -2.91300658316853E-14   4.10187404900475E-23
      1.33423382870238E-08   1.33423091569581E-08  -6.82724876216884E-19  -3.14822500657451E-01  -3.14822500657409E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.17578507674236E-11   0.00000000000000E+00  -4.17578507674236E-11
      2.74857904051042E-18  -3.50024140349805E-02  -3.08118757107266E-02   0.00000000000000E+00   1.16619920565335E-13
     -4.00375364385707E-23  -1.33006679261111E-08  -1.33005513061906E-08  -2.06585416429354E-18
      1.45412808016913E-06
      0.00000000000000E+00  -9.39268574000214E-12   0.00000000000000E+00  -3.88081378347334E-14   1.86353195362352E-23
      9.39270639989852E-09   9.39266759176071E-09  -6.56703503995971E-19  -3.27903136094010E-01  -3.27903136093981E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.89852836676932E-11   0.00000000000000E+00  -2.89852836676932E-11
      2.60365262217195E-18  -1.74606157646531E-02  -1.45104402770667E-02   0.00000000000000E+00   8.20687773680495E-14
     -1.87851098446893E-23  -9.36376437687038E-09  -9.36368230809303E-09  -1.94694911817598E-18
      1.45912808016913E-06
      0.00000000000000E+00  -7.26556162627582E-12   0.00000000000000E+00  -2.08230796349850E-14   1.06535691885978E-23
      7.26554416220875E-09   7.26552333912912E-09  -6.29190575796504E-19  -3.40383676860830E-01  -3.40383676860809E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.09982789546665E-11   0.00000000000000E+00  -2.09982789546665E-11
      2.49866122739862E-18  -1.07848514031181E-02  -8.50234667185459E-03   0.00000000000000E+00   4.54741795397408E-14
     -1.05780953113774E-23  -7.24457053435399E-09  -7.24452506017446E-09  -1.86947065160212E-18
      1.46412808016913E-06
      0.00000000000000E+00  -6.48258524158165E-12   0.00000000000000E+00  -7.57012017547873E-15   7.07685420791779E-24
      6.48262345106034E-09   6.48261588094017E-09  -6.01661540076886E-19  -3.52267908025219E-01  -3.52267908025201E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.75934222945660E-11   0.00000000000000E+00  -1.75934222945660E-11
      2.41069411592579E-18  -8.11167375390907E-03  -6.07476191202979E-03   0.00000000000000E+00   2.53650802016662E-14
     -8.09069917960959E-24  -6.46504782372581E-09  -6.46502245864561E-09  -1.80903257584890E-18
      1.46912808016913E-06
      0.00000000000000E+00  -6.22496075371454E-12   0.00000000000000E+00  -2.40859537112056E-15   5.43095310501262E-24
      6.22495064662692E-09   6.22494823803156E-09  -5.74742817499060E-19  -3.63567898930582E-01  -3.63567898930566E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.60783133917265E-11   0.00000000000000E+00  -1.60783133917265E-11
      2.33030254896716E-18  -6.77336705356728E-03  -4.81715868395707E-03   0.00000000000000E+00   1.71336777349673E-14
     -6.49317520734837E-24  -6.20888705831757E-09  -6.20886992463984E-09  -1.75555973146810E-18
      1.47412808016913E-06
      0.00000000000000E+00  -6.13063620860241E-12   0.00000000000000E+00  -8.10017485254029E-16   4.41017206528702E-24
      6.13065913007511E-09   6.13065832005763E-09  -5.48729022574965E-19  -3.74288244680044E-01  -3.74288244680028E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.51933624629460E-11   0.00000000000000E+00  -1.51933624629460E-11
      2.25433573665243E-18  -5.93742082954909E-03  -4.01063988119607E-03   0.00000000000000E+00   1.36010174255232E-14
     -5.43505282771946E-24  -6.11547855861210E-09  -6.11546495759468E-09  -1.70560671407746E-18
      1.47912808016913E-06
      0.00000000000000E+00  -6.08535675315910E-12   0.00000000000000E+00  -3.38850922822944E-16   3.70509641831627E-24
      6.08537722779276E-09   6.08537688894184E-09  -5.23891077040741E-19  -3.84396682230930E-01  -3.84396682230915E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.44755776977756E-11   0.00000000000000E+00  -1.44755776977756E-11
      2.18195784816355E-18  -5.34982783414606E-03  -3.43708621524151E-03   0.00000000000000E+00   1.15717487328264E-14
     -4.66362331952595E-24  -6.07091288299279E-09  -6.07090131124406E-09  -1.65806677112281E-18
      1.48412808016913E-06
      0.00000000000000E+00  -6.05688488462477E-12   0.00000000000000E+00  -1.85311883001176E-16   3.19807517779150E-24
      6.05688524239874E-09   6.05688505708686E-09  -5.00697470520841E-19  -3.93760993365913E-01  -3.93760993365900E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.36376219874798E-11   0.00000000000000E+00  -1.36376219874798E-11
      2.11376973822615E-18  -4.91935338981371E-03  -3.01532355932823E-03   0.00000000000000E+00   9.95487119509145E-15
     -4.08673731148204E-24  -6.04325738997058E-09  -6.04324743509939E-09  -1.61307226770531E-18
      1.48912808016913E-06
      0.00000000000000E+00  -6.03502583716938E-12   0.00000000000000E+00  -1.21770330780610E-16   2.83189959926740E-24
      6.03503526818230E-09   6.03503514641197E-09  -4.80041891569379E-19  -4.02064093987391E-01  -4.02064093987378E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23272747384544E-11   0.00000000000000E+00  -1.23272747384544E-11
      2.05213336453388E-18  -4.60516756459020E-03  -2.70760821365597E-03   0.00000000000000E+00   8.30981696031157E-15
     -3.66502642482701E-24  -6.02271618149047E-09  -6.02270787167351E-09  -1.57209147296450E-18
      1.49412808016913E-06
      0.00000000000000E+00  -6.01537106340697E-12   0.00000000000000E+00  -1.26842073482221E-17   2.57635191861675E-24
      6.01535884074254E-09   6.01535882805833E-09  -4.63384258397639E-19  -4.08748231644355E-01  -4.08748231644345E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01087865928008E-11   0.00000000000000E+00  -1.01087865928008E-11
      2.00158943156988E-18  -4.38732869701729E-03  -2.49526910498771E-03   0.00000000000000E+00   6.29613982757742E-15
     -3.38194694961296E-24  -6.00525633760535E-09  -6.00525004146553E-09  -1.53820517317224E-18
      1.49912808016913E-06
      0.00000000000000E+00  -5.99488968700969E-12   0.00000000000000E+00  -1.63499747117922E-16   2.41710969879105E-24
      5.99486124622955E-09   5.99486108272981E-09  -4.52805834073822E-19  -4.12991843834905E-01  -4.12991843834898E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.51278193638510E-12   0.00000000000000E+00  -6.51278193638510E-12
      1.96902552188795E-18  -4.25874614515334E-03  -2.37201129930443E-03   0.00000000000000E+00   4.00113129120141E-15
     -3.23816075695848E-24  -5.98835230192471E-09  -5.98834830079342E-09  -1.51621968781413E-18
      1.50000000000000E-06
      0.00000000000000E+00  -5.99057298436093E-12   0.00000000000000E+00  -2.09512059358570E-16   2.39118070581416E-24
      5.99057003260880E-09   5.99056982309674E-09  -4.51203583261217E-19  -4.13634697737696E-01  -4.13634697737690E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.69736308959379E-12   0.00000000000000E+00  -5.69736308959379E-12
      1.96405787802647E-18  -4.23946710841882E-03  -2.35382732663718E-03   0.00000000000000E+00   3.48042463775782E-15
     -3.22132752740089E-24  -5.98487594043179E-09  -5.98487246000715E-09  -1.51285429476526E-18
}
